/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.osgi.framework.Bundle;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.AbstractPackageAdder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundlePackageAdder
extends AbstractPackageAdder
implements IPackageAdder {
    private static Logger logger = Logger.getLogger(BundlePackageAdder.class.getName());

    public BundlePackageAdder(Bundle bundle, Map<String, Object> globals) {
        super(bundle, globals);
    }

    public BundlePackageAdder(Bundle bundle, Map<String, Object> globals, String workingMemoryName) {
        super(bundle, globals, workingMemoryName);
    }

    @Override
    public void addPackage(KnowledgeBuilder builder, KnowledgeBase ruleBase) {
        Enumeration drlXmlPaths;
        Enumeration drlPaths = this.bundle.findEntries("/", "*.drl", true);
        if (drlPaths != null) {
            while (drlPaths.hasMoreElements()) {
                URL drlPath = (URL)drlPaths.nextElement();
                String externalForm = drlPath.toExternalForm();
                URL dslPath = this.bundle.getEntry(externalForm.substring(0, externalForm.length() - 4) + ".dsl");
                if (dslPath != null) {
                    builder.add(ResourceFactory.newUrlResource((URL)dslPath), ResourceType.DSL);
                    logger.log(Level.INFO, dslPath.getPath() + " loaded");
                }
                builder.add(ResourceFactory.newUrlResource((URL)drlPath), ResourceType.DRL);
                logger.log(Level.INFO, drlPath.getPath() + " loaded");
            }
        }
        if ((drlXmlPaths = this.bundle.findEntries("/", "*.drl.xml", true)) != null) {
            while (drlXmlPaths.hasMoreElements()) {
                URL drlXmlPath = (URL)drlXmlPaths.nextElement();
                builder.add(ResourceFactory.newUrlResource((URL)drlXmlPath), ResourceType.XDRL);
                logger.log(Level.INFO, drlXmlPath.getPath() + " loaded");
            }
        }
        if (builder.hasErrors()) {
            logger.log(Level.WARNING, builder.getErrors().toString());
        }
        ruleBase.addKnowledgePackages(builder.getKnowledgePackages());
    }
}

