/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.rules.osgi.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.conf.EventProcessingOption;
import org.drools.conf.KnowledgeBaseOption;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.ow2.jasmine.rules.AbstractDroolsWorkingMemory;
import org.ow2.jasmine.rules.api.DroolsWorkingMemoryState;
import org.ow2.jasmine.rules.osgi.api.IOSGiDroolsWorkingMemory;
import org.ow2.jasmine.rules.osgi.api.IPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.DrlPackageAdder;
import org.ow2.jasmine.rules.osgi.impl.MultiBundleClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiDroolsWorkingMemory
extends AbstractDroolsWorkingMemory
implements IOSGiDroolsWorkingMemory {
    private static Logger logger = Logger.getLogger(OSGiDroolsWorkingMemory.class.getName());
    private final MultiBundleClassLoader multiBundleClassLoader;
    protected final Map<ServiceReference, IPackageAdder> packageAdders;

    public OSGiDroolsWorkingMemory(BundleContext context, Map<ServiceReference, IPackageAdder> packageAdders) throws Exception {
        super(logger);
        this.packageAdders = packageAdders;
        this.multiBundleClassLoader = new MultiBundleClassLoader(this.getClass().getClassLoader());
        this.multiBundleClassLoader.addBundleClassLoader(context.getBundle());
        this.initKnowledgeBuilderConfiguration(this.multiBundleClassLoader);
    }

    @Override
    public void start() throws Exception {
        if (!this.packageAdders.isEmpty()) {
            this.addPackages(this.packageAdders.values());
        } else {
            this.state = DroolsWorkingMemoryState.IDLE;
        }
    }

    @Override
    public void addPackage(ServiceReference serviceReference, IPackageAdder packageAdder) throws Exception {
        if (this.packageAdders.put(serviceReference, packageAdder) == null && this.state != DroolsWorkingMemoryState.STOPPED) {
            this.addPackages(Collections.singletonList(packageAdder));
        }
    }

    @Override
    public void removePackage(ServiceReference serviceReference) throws Exception {
        IPackageAdder packageAdder = this.packageAdders.get(serviceReference);
        if (packageAdder != null) {
            this.packageAdders.remove(serviceReference);
            this.multiBundleClassLoader.removeBundleClassLoader(packageAdder.getBundle());
            if (packageAdder instanceof DrlPackageAdder) {
                this.knowledgeBase.removeKnowledgePackage(((DrlPackageAdder)packageAdder).getPackageName());
            }
            if (this.packageAdders.size() < 1) {
                if (this.state != DroolsWorkingMemoryState.STOPPED) {
                    this.stop(DroolsWorkingMemoryState.IDLE);
                } else {
                    this.stop(DroolsWorkingMemoryState.STOPPED);
                }
            } else {
                if (this.state != DroolsWorkingMemoryState.STOPPED) {
                    this.stop(DroolsWorkingMemoryState.IDLE);
                } else {
                    this.stop(DroolsWorkingMemoryState.STOPPED);
                }
                this.knowledgeBase = null;
                this.knowledgeSession = null;
                if (this.packageAdders.size() > 0) {
                    this.addPackages(this.packageAdders.values());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPackages(Collection<IPackageAdder> packageAdders) throws Exception {
        ClassLoader lastClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            if (this.knowledgeBase == null) {
                KnowledgeBaseConfiguration kbaseConfig = KnowledgeBaseFactory.newKnowledgeBaseConfiguration(null, (ClassLoader)this.multiBundleClassLoader);
                kbaseConfig.setOption((KnowledgeBaseOption)EventProcessingOption.STREAM);
                this.knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)kbaseConfig);
            }
            for (IPackageAdder packageAdder : packageAdders) {
                Map<String, Object> globals;
                KnowledgeBuilder packageBuilder = this.newKnowledgeBuilder();
                this.multiBundleClassLoader.addBundleClassLoader(packageAdder.getBundle());
                packageAdder.addPackage(packageBuilder, this.knowledgeBase);
                if (this.knowledgeSession == null || (globals = packageAdder.getGlobals()) == null) continue;
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    this.knowledgeSession.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            if (this.knowledgeSession == null) {
                this.createWorkingMemory();
                for (IPackageAdder packageAdder : packageAdders) {
                    Map<String, Object> globals = packageAdder.getGlobals();
                    if (globals == null) continue;
                    for (Map.Entry<String, Object> entry : globals.entrySet()) {
                        this.knowledgeSession.setGlobal(entry.getKey(), entry.getValue());
                    }
                }
            }
            this.startRuleExecutor();
        }
        finally {
            Thread.currentThread().setContextClassLoader(lastClassLoader);
        }
    }
}

