/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.transaction.TransactionManager;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.list.CursorableLinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleRuntimeException;
import org.mule.config.ConfigurationException;
import org.mule.config.MuleConfiguration;
import org.mule.config.MuleManifest;
import org.mule.config.ThreadingProfile;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.Message;
import org.mule.impl.container.MultiContainerContext;
import org.mule.impl.internal.admin.MuleAdminAgent;
import org.mule.impl.internal.notifications.AdminNotification;
import org.mule.impl.internal.notifications.AdminNotificationListener;
import org.mule.impl.internal.notifications.ComponentNotification;
import org.mule.impl.internal.notifications.ComponentNotificationListener;
import org.mule.impl.internal.notifications.ConnectionNotification;
import org.mule.impl.internal.notifications.ConnectionNotificationListener;
import org.mule.impl.internal.notifications.CustomNotification;
import org.mule.impl.internal.notifications.CustomNotificationListener;
import org.mule.impl.internal.notifications.ExceptionNotification;
import org.mule.impl.internal.notifications.ExceptionNotificationListener;
import org.mule.impl.internal.notifications.ManagementNotification;
import org.mule.impl.internal.notifications.ManagementNotificationListener;
import org.mule.impl.internal.notifications.ManagerNotification;
import org.mule.impl.internal.notifications.ManagerNotificationListener;
import org.mule.impl.internal.notifications.MessageNotification;
import org.mule.impl.internal.notifications.MessageNotificationListener;
import org.mule.impl.internal.notifications.ModelNotification;
import org.mule.impl.internal.notifications.ModelNotificationListener;
import org.mule.impl.internal.notifications.NotificationException;
import org.mule.impl.internal.notifications.SecurityNotification;
import org.mule.impl.internal.notifications.SecurityNotificationListener;
import org.mule.impl.internal.notifications.ServerNotificationManager;
import org.mule.impl.internal.notifications.TransactionNotification;
import org.mule.impl.internal.notifications.TransactionNotificationListener;
import org.mule.impl.model.ModelFactory;
import org.mule.impl.security.MuleSecurityManager;
import org.mule.impl.work.MuleWorkManager;
import org.mule.management.stats.AllStatistics;
import org.mule.umo.UMOException;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.FatalException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOServerNotification;
import org.mule.umo.manager.UMOServerNotificationListener;
import org.mule.umo.manager.UMOWorkManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.CollectionUtils;
import org.mule.util.SpiUtils;
import org.mule.util.StringMessageUtils;
import org.mule.util.StringUtils;
import org.mule.util.UUID;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueuePersistenceStrategy;
import org.mule.util.queue.TransactionalQueueManager;

public class MuleManager
implements UMOManager {
    private static UMOManager instance = null;
    private static MuleConfiguration config = new MuleConfiguration();
    private Map connectors = new HashMap();
    private Map endpointIdentifiers = new HashMap();
    private Map applicationProps = new HashMap();
    private Map agents = new LinkedHashMap();
    private Map endpoints = new HashMap();
    private Map models = new LinkedHashMap();
    private String id = UUID.getUUID();
    private TransactionManager transactionManager = null;
    private Map transformers = new HashMap();
    private AtomicBoolean initialised = new AtomicBoolean(false);
    private AtomicBoolean initialising = new AtomicBoolean(false);
    private AtomicBoolean started = new AtomicBoolean(false);
    private AtomicBoolean starting = new AtomicBoolean(false);
    private AtomicBoolean stopping = new AtomicBoolean(false);
    private AtomicBoolean disposed = new AtomicBoolean(false);
    private Map interceptorsMap = new HashMap();
    private long startDate = 0L;
    private AllStatistics stats = new AllStatistics();
    private ServerNotificationManager notificationManager = null;
    private MultiContainerContext containerContext = null;
    private UMOSecurityManager securityManager;
    private QueueManager queueManager;
    private UMOWorkManager workManager;
    private static Log logger = LogFactory.getLog(MuleManager.class);

    private MuleManager() {
        if (config == null) {
            config = new MuleConfiguration();
        }
        this.containerContext = new MultiContainerContext();
        this.securityManager = new MuleSecurityManager();
        this.notificationManager = new ServerNotificationManager();
        this.notificationManager.registerEventType(ManagerNotification.class, ManagerNotificationListener.class);
        this.notificationManager.registerEventType(ModelNotification.class, ModelNotificationListener.class);
        this.notificationManager.registerEventType(ComponentNotification.class, ComponentNotificationListener.class);
        this.notificationManager.registerEventType(SecurityNotification.class, SecurityNotificationListener.class);
        this.notificationManager.registerEventType(ManagementNotification.class, ManagementNotificationListener.class);
        this.notificationManager.registerEventType(AdminNotification.class, AdminNotificationListener.class);
        this.notificationManager.registerEventType(CustomNotification.class, CustomNotificationListener.class);
        this.notificationManager.registerEventType(ConnectionNotification.class, ConnectionNotificationListener.class);
        this.notificationManager.registerEventType(ExceptionNotification.class, ExceptionNotificationListener.class);
        this.notificationManager.registerEventType(TransactionNotification.class, TransactionNotificationListener.class);
    }

    public static synchronized UMOManager getInstance() {
        if (instance == null) {
            logger.info("Creating new MuleManager instance");
            Class clazz = SpiUtils.findService(UMOManager.class, MuleManager.class.getName(), MuleManager.class);
            try {
                instance = (UMOManager)clazz.newInstance();
                MuleManager.registerSystemModel(config.getSystemModelType());
            }
            catch (Exception e) {
                throw new MuleRuntimeException(CoreMessages.failedToCreateManagerInstance(clazz.getName()), (Throwable)e);
            }
        }
        return instance;
    }

    public static synchronized boolean isInstanciated() {
        return instance != null;
    }

    public static synchronized void setInstance(UMOManager manager) {
        instance = manager;
        if (instance == null) {
            config = new MuleConfiguration();
        }
    }

    public AllStatistics getStatistics() {
        return this.stats;
    }

    public void setStatistics(AllStatistics stat) {
        this.stats = stat;
    }

    public static synchronized MuleConfiguration getConfiguration() {
        return config;
    }

    public static synchronized void setConfiguration(MuleConfiguration config) throws UMOException {
        if (config == null) {
            throw new IllegalArgumentException(CoreMessages.objectIsNull("MuleConfiguration object").getMessage());
        }
        MuleManager.config = config;
        MuleManager.registerSystemModel(config.getSystemModelType());
    }

    protected static void registerSystemModel(String type) throws UMOException {
        if (instance != null) {
            UMOModel model = instance.lookupModel(type);
            if (model != null && model.getComponentNames().hasNext()) {
                throw new IllegalStateException("System model is already registered and contains components. Cannot overwrite");
            }
            model = ModelFactory.createModel(config.getSystemModelType());
            model.setName("_system");
            instance.registerModel(model);
        }
    }

    public synchronized void dispose() {
        if (this.disposed.get()) {
            return;
        }
        try {
            if (this.started.get()) {
                this.stop();
            }
        }
        catch (UMOException e) {
            logger.error("Failed to stop manager: " + e.getMessage(), e);
        }
        this.disposed.set(true);
        this.disposeConnectors();
        Iterator i = this.models.values().iterator();
        while (i.hasNext()) {
            UMOModel model = (UMOModel)i.next();
            model.dispose();
        }
        this.disposeAgents();
        this.transformers.clear();
        this.endpoints.clear();
        this.endpointIdentifiers.clear();
        this.containerContext.dispose();
        this.containerContext = null;
        this.fireSystemEvent(new ManagerNotification(this, 108));
        this.transformers = null;
        this.endpoints = null;
        this.endpointIdentifiers = null;
        this.initialised.set(false);
        if (this.notificationManager != null) {
            this.notificationManager.dispose();
        }
        if (this.workManager != null) {
            this.workManager.dispose();
        }
        if (this.queueManager != null) {
            this.queueManager.close();
            this.queueManager = null;
        }
        if (this.startDate > 0L && logger.isInfoEnabled()) {
            logger.info(this.getEndSplash());
        }
        config = new MuleConfiguration();
        instance = null;
    }

    private synchronized void disposeConnectors() {
        this.fireSystemEvent(new ManagerNotification(this, 109));
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.dispose();
        }
        this.fireSystemEvent(new ManagerNotification(this, 110));
    }

    public Object getProperty(Object key) {
        return this.applicationProps.get(key);
    }

    public Map getProperties() {
        return this.applicationProps;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public UMOConnector lookupConnector(String name) {
        return (UMOConnector)this.connectors.get(name);
    }

    public String lookupEndpointIdentifier(String logicalName, String defaultName) {
        String name = (String)this.endpointIdentifiers.get(logicalName);
        if (name == null) {
            return defaultName;
        }
        return name;
    }

    public UMOEndpoint lookupEndpoint(String logicalName) {
        UMOEndpoint endpoint = (UMOEndpoint)this.endpoints.get(logicalName);
        if (endpoint != null) {
            return (UMOEndpoint)endpoint.clone();
        }
        return null;
    }

    public UMOEndpoint lookupEndpointByAddress(String address) {
        UMOEndpoint endpoint = null;
        if (address != null) {
            boolean found = false;
            Iterator iterator = this.endpoints.keySet().iterator();
            while (!found && iterator.hasNext()) {
                endpoint = (UMOEndpoint)this.endpoints.get(iterator.next());
                found = address.equals(endpoint.getEndpointURI().toString());
            }
        }
        return endpoint;
    }

    public UMOTransformer lookupTransformer(String name) {
        UMOTransformer trans = (UMOTransformer)this.transformers.get(name);
        if (trans != null) {
            try {
                return (UMOTransformer)trans.clone();
            }
            catch (Exception e) {
                throw new MuleRuntimeException(CoreMessages.failedToClone("Transformer: " + trans.getName()), (Throwable)e);
            }
        }
        return null;
    }

    public void registerConnector(UMOConnector connector) throws UMOException {
        this.connectors.put(connector.getName(), connector);
        if (this.initialised.get() || this.initialising.get()) {
            connector.initialise();
        }
        if ((this.started.get() || this.starting.get()) && !connector.isStarted()) {
            connector.startConnector();
        }
    }

    public void unregisterConnector(String connectorName) throws UMOException {
        UMOConnector c = (UMOConnector)this.connectors.remove(connectorName);
        if (c != null) {
            c.dispose();
        }
    }

    public void registerEndpointIdentifier(String logicalName, String endpoint) {
        this.endpointIdentifiers.put(logicalName, endpoint);
    }

    public void unregisterEndpointIdentifier(String logicalName) {
        this.endpointIdentifiers.remove(logicalName);
    }

    public void registerEndpoint(UMOEndpoint endpoint) {
        this.endpoints.put(endpoint.getName(), endpoint);
    }

    public void unregisterEndpoint(String endpointName) {
        UMOEndpoint p = (UMOEndpoint)this.endpoints.get(endpointName);
        if (p != null) {
            this.endpoints.remove(p);
        }
    }

    public void registerTransformer(UMOTransformer transformer) throws InitialisationException {
        transformer.initialise();
        this.transformers.put(transformer.getName(), transformer);
        logger.info("Transformer " + transformer.getName() + " has been initialised successfully");
    }

    public void unregisterTransformer(String transformerName) {
        this.transformers.remove(transformerName);
    }

    public void setProperty(Object key, Object value) {
        this.applicationProps.put(key, value);
    }

    public void addProperties(Map props) {
        this.applicationProps.putAll(props);
    }

    public void setTransactionManager(TransactionManager newManager) throws UMOException {
        if (this.transactionManager != null) {
            throw new ConfigurationException(CoreMessages.transactionManagerAlreadySet());
        }
        this.transactionManager = newManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialise() throws UMOException {
        this.validateEncoding();
        this.validateOSEncoding();
        this.validateXML();
        if (!this.initialised.get()) {
            this.initialising.set(true);
            this.startDate = System.currentTimeMillis();
            if (this.workManager == null) {
                ThreadingProfile tp = config.getDefaultThreadingProfile();
                logger.debug("Creating default work manager using default threading profile: " + tp);
                this.workManager = new MuleWorkManager(tp, "UMOManager");
                this.workManager.start();
            }
            this.notificationManager.start(this.workManager);
            if (config.isEnableMessageEvents()) {
                this.notificationManager.registerEventType(MessageNotification.class, MessageNotificationListener.class);
            }
            this.fireSystemEvent(new ManagerNotification(this, 101));
            if (this.id == null) {
                logger.warn("No unique id has been set on this manager");
            }
            try {
                if (this.securityManager != null) {
                    this.securityManager.initialise();
                }
                if (this.queueManager == null) {
                    try {
                        TransactionalQueueManager queueMgr = new TransactionalQueueManager();
                        QueuePersistenceStrategy ps = MuleManager.getConfiguration().getPersistenceStrategy();
                        queueMgr.setPersistenceStrategy(ps);
                        this.queueManager = queueMgr;
                    }
                    catch (Exception e) {
                        throw new InitialisationException(CoreMessages.initialisationFailure("QueueManager"), (Object)e);
                    }
                }
                this.initialiseConnectors();
                this.initialiseEndpoints();
                this.initialiseAgents();
                Iterator i = this.models.values().iterator();
                while (i.hasNext()) {
                    UMOModel model = (UMOModel)i.next();
                    model.initialise();
                }
                Object var4_4 = null;
                this.initialised.set(true);
                this.initialising.set(false);
                this.fireSystemEvent(new ManagerNotification(this, 102));
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.initialised.set(true);
                this.initialising.set(false);
                this.fireSystemEvent(new ManagerNotification(this, 102));
                throw throwable;
            }
        }
    }

    protected void validateEncoding() throws FatalException {
        String encoding = System.getProperty("org.mule.encoding");
        if (encoding == null) {
            encoding = config.getEncoding();
            System.setProperty("org.mule.encoding", encoding);
        } else {
            config.setEncoding(encoding);
        }
        if (!Charset.isSupported(config.getEncoding())) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("encoding", config.getEncoding()), (Object)this);
        }
    }

    protected void validateOSEncoding() throws FatalException {
        String encoding = System.getProperty("org.mule.osEncoding");
        if (encoding == null) {
            encoding = config.getOSEncoding();
            System.setProperty("org.mule.osEncoding", encoding);
        } else {
            config.setOSEncoding(encoding);
        }
        if (!Charset.isSupported(config.getOSEncoding())) {
            throw new FatalException(CoreMessages.propertyHasInvalidValue("osEncoding", config.getOSEncoding()), (Object)this);
        }
    }

    protected void validateXML() throws FatalException {
        SAXParserFactory f = SAXParserFactory.newInstance();
        if (f == null || f.getClass().getName().indexOf("crimson") != -1) {
            throw new FatalException(CoreMessages.valueIsInvalidFor(f.getClass().getName(), "javax.xml.parsers.SAXParserFactory"), (Object)this);
        }
    }

    protected void registerAdminAgent() throws UMOException {
        boolean disable = MapUtils.getBooleanValue(System.getProperties(), "org.mule.disable.server.connections", false);
        if (StringUtils.isBlank(config.getServerUrl())) {
            logger.info("Server endpointUri is null, not registering Mule Admin agent");
            disable = true;
        }
        if (disable) {
            this.unregisterAgent("Mule Admin");
        } else if (this.lookupAgent("Mule Admin") == null) {
            this.registerAgent(new MuleAdminAgent());
        }
    }

    protected void initialiseEndpoints() throws InitialisationException {
        Iterator iterator = this.endpoints.values().iterator();
        while (iterator.hasNext()) {
            UMOEndpoint ep = (UMOEndpoint)iterator.next();
            ep.initialise();
            ep.setCreateConnector(0);
        }
    }

    public synchronized void start() throws UMOException {
        this.initialise();
        if (!this.started.get()) {
            this.starting.set(true);
            this.fireSystemEvent(new ManagerNotification(this, 103));
            this.registerAdminAgent();
            if (this.queueManager != null) {
                this.queueManager.start();
            }
            this.startConnectors();
            this.startAgents();
            this.fireSystemEvent(new ManagerNotification(this, 111));
            Iterator i = this.models.values().iterator();
            while (i.hasNext()) {
                UMOModel model = (UMOModel)i.next();
                model.start();
            }
            this.fireSystemEvent(new ManagerNotification(this, 112));
            this.started.set(true);
            this.starting.set(false);
            if (logger.isInfoEnabled()) {
                logger.info(this.getStartSplash());
            }
            this.fireSystemEvent(new ManagerNotification(this, 104));
        }
    }

    public void start(String serverUrl) throws UMOException {
        config.setServerUrl(serverUrl);
        this.start();
    }

    private void startConnectors() throws UMOException {
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.startConnector();
        }
        logger.info("Connectors have been started successfully");
    }

    private void initialiseConnectors() throws InitialisationException {
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.initialise();
        }
        logger.info("Connectors have been initialised successfully");
    }

    public synchronized void stop() throws UMOException {
        this.started.set(false);
        this.stopping.set(true);
        this.fireSystemEvent(new ManagerNotification(this, 105));
        this.stopConnectors();
        this.stopAgents();
        if (this.queueManager != null) {
            this.queueManager.stop();
        }
        logger.debug("Stopping model...");
        this.fireSystemEvent(new ManagerNotification(this, 113));
        Iterator i = this.models.values().iterator();
        while (i.hasNext()) {
            UMOModel model = (UMOModel)i.next();
            model.stop();
        }
        this.fireSystemEvent(new ManagerNotification(this, 114));
        this.stopping.set(false);
        this.initialised.set(false);
        this.fireSystemEvent(new ManagerNotification(this, 106));
    }

    private void stopConnectors() throws UMOException {
        logger.debug("Stopping connectors...");
        Iterator iterator = this.connectors.values().iterator();
        while (iterator.hasNext()) {
            UMOConnector c = (UMOConnector)iterator.next();
            c.stopConnector();
        }
        logger.info("Connectors have been stopped successfully");
    }

    public UMOModel lookupModel(String name) {
        return (UMOModel)this.models.get(name);
    }

    public void registerModel(UMOModel model) throws UMOException {
        this.models.put(model.getName(), model);
        if (this.initialised.get()) {
            model.initialise();
        }
        if (this.started.get()) {
            model.start();
        }
    }

    public void unregisterModel(String name) {
        UMOModel model = this.lookupModel(name);
        if (model != null) {
            this.models.remove(model.getName());
            model.dispose();
        }
    }

    public Map getModels() {
        return Collections.unmodifiableMap(this.models);
    }

    public void registerInterceptorStack(String name, UMOInterceptorStack stack) {
        this.interceptorsMap.put(name, stack);
    }

    public UMOInterceptorStack lookupInterceptorStack(String name) {
        return (UMOInterceptorStack)this.interceptorsMap.get(name);
    }

    public Map getConnectors() {
        return Collections.unmodifiableMap(this.connectors);
    }

    public Map getEndpointIdentifiers() {
        return Collections.unmodifiableMap(this.endpointIdentifiers);
    }

    public Map getEndpoints() {
        return Collections.unmodifiableMap(this.endpoints);
    }

    public Map getTransformers() {
        return Collections.unmodifiableMap(this.transformers);
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public boolean isInitialised() {
        return this.initialised.get();
    }

    public boolean isInitialising() {
        return this.initialising.get();
    }

    public boolean isStopping() {
        return this.stopping.get();
    }

    public long getStartDate() {
        return this.startDate;
    }

    private String getStartSplash() {
        String notset = CoreMessages.notSet().getMessage();
        ArrayList<Object> message = new ArrayList<Object>();
        message.add(StringUtils.defaultString(MuleManifest.getProductDescription(), notset));
        message.add(CoreMessages.version().getMessage() + " " + StringUtils.defaultString(MuleManifest.getProductVersion(), notset) + " Build: " + StringUtils.defaultString(MuleManifest.getBuildNumber(), notset));
        message.add(StringUtils.defaultString(MuleManifest.getVendorName(), notset));
        message.add(StringUtils.defaultString(MuleManifest.getProductMoreInfo(), notset));
        message.add(" ");
        message.add(CoreMessages.serverStartedAt(this.getStartDate()));
        message.add("Server ID: " + this.id);
        message.add("JDK: " + System.getProperty("java.version") + " (" + System.getProperty("java.vm.info") + ")");
        String patch = System.getProperty("sun.os.patch.level", null);
        message.add("OS: " + System.getProperty("os.name") + (patch != null && !"unknown".equalsIgnoreCase(patch) ? " - " + patch : "") + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")");
        try {
            InetAddress host = InetAddress.getLocalHost();
            message.add("Host: " + host.getHostName() + " (" + host.getHostAddress() + ")");
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        message.add(" ");
        if (this.agents.size() == 0) {
            message.add(CoreMessages.agentsRunning().getMessage() + " " + CoreMessages.none());
        } else {
            message.add(CoreMessages.agentsRunning());
            Iterator iterator = this.agents.values().iterator();
            while (iterator.hasNext()) {
                UMOAgent umoAgent = (UMOAgent)iterator.next();
                message.add("  " + umoAgent.getDescription());
            }
        }
        return StringMessageUtils.getBoilerPlate(message, '*', 70);
    }

    private String getEndSplash() {
        ArrayList<Message> message = new ArrayList<Message>(2);
        long currentTime = System.currentTimeMillis();
        message.add(CoreMessages.shutdownNormally(new Date()));
        long duration = 10L;
        if (this.startDate > 0L) {
            duration = currentTime - this.startDate;
        }
        message.add(CoreMessages.serverWasUpForDuration(duration));
        return StringMessageUtils.getBoilerPlate(message, '*', 78);
    }

    public void registerAgent(UMOAgent agent) throws UMOException {
        this.agents.put(agent.getName(), agent);
        agent.registered();
        if (this.initialised.get()) {
            agent.initialise();
        }
        if (this.started.get() || this.starting.get()) {
            agent.start();
        }
    }

    public UMOAgent lookupAgent(String name) {
        return (UMOAgent)this.agents.get(name);
    }

    public UMOAgent unregisterAgent(String name) throws UMOException {
        if (name == null) {
            return null;
        }
        UMOAgent agent = (UMOAgent)this.agents.remove(name);
        if (agent != null) {
            agent.dispose();
            agent.unregistered();
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialiseAgents() throws InitialisationException {
        logger.info("Initialising agents...");
        Collection agentsSnapshot = this.agents.values();
        CursorableLinkedList agentRegistrationQueue = new CursorableLinkedList(agentsSnapshot);
        CursorableLinkedList.Cursor cursor = agentRegistrationQueue.cursor();
        try {
            while (cursor.hasNext()) {
                UMOAgent umoAgent = (UMOAgent)cursor.next();
                int originalSize = agentsSnapshot.size();
                logger.debug("Initialising agent: " + umoAgent.getName());
                umoAgent.initialise();
                cursor.remove();
                int newSize = agentsSnapshot.size();
                int delta = newSize - originalSize;
                if (delta <= 0) continue;
                Collection tail = CollectionUtils.retainAll(agentsSnapshot, agentRegistrationQueue);
                Collection head = CollectionUtils.subtract(agentsSnapshot, tail);
                agentRegistrationQueue.clear();
                agentRegistrationQueue.addAll(head);
                agentRegistrationQueue.addAll(tail);
                this.agents.clear();
                Iterator it = agentRegistrationQueue.iterator();
                while (it.hasNext()) {
                    UMOAgent theAgent = (UMOAgent)it.next();
                    this.agents.put(theAgent.getName(), theAgent);
                }
            }
        }
        finally {
            cursor.close();
        }
        logger.info("Agents Successfully Initialised");
    }

    protected void startAgents() throws UMOException {
        logger.info("Starting agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.info("Starting agent: " + umoAgent.getDescription());
            umoAgent.start();
        }
        logger.info("Agents Successfully Started");
    }

    protected void stopAgents() throws UMOException {
        logger.info("Stopping agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug("Stopping agent: " + umoAgent.getName());
            umoAgent.stop();
        }
        logger.info("Agents Successfully Stopped");
    }

    protected void disposeAgents() {
        logger.info("disposing agents...");
        Iterator iterator = this.agents.values().iterator();
        while (iterator.hasNext()) {
            UMOAgent umoAgent = (UMOAgent)iterator.next();
            logger.debug("Disposing agent: " + umoAgent.getName());
            umoAgent.dispose();
        }
        logger.info("Agents Successfully Disposed");
    }

    public void setContainerContext(UMOContainerContext container) throws UMOException {
        if (container == null) {
            if (this.containerContext != null) {
                this.containerContext.dispose();
            }
            this.containerContext = new MultiContainerContext();
        } else {
            container.initialise();
            this.containerContext.addContainer(container);
        }
    }

    public UMOContainerContext getContainerContext() {
        return this.containerContext;
    }

    public void registerListener(UMOServerNotificationListener l) throws NotificationException {
        this.registerListener(l, null);
    }

    public void registerListener(UMOServerNotificationListener l, String resourceIdentifier) throws NotificationException {
        if (this.notificationManager == null) {
            throw new NotificationException(CoreMessages.serverEventManagerNotEnabled());
        }
        this.notificationManager.registerListener(l, resourceIdentifier);
    }

    public void unregisterListener(UMOServerNotificationListener l) {
        if (this.notificationManager != null) {
            this.notificationManager.unregisterListener(l);
        }
    }

    protected void fireSystemEvent(UMOServerNotification e) {
        if (this.notificationManager != null) {
            this.notificationManager.fireEvent(e);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Event Manager is not enabled, ignoring event: " + e);
        }
    }

    public void fireNotification(UMOServerNotification notification) {
        if (this.notificationManager != null) {
            this.notificationManager.fireEvent(notification);
        } else if (logger.isDebugEnabled()) {
            logger.debug("Event Manager is not enabled, ignoring notification: " + notification);
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setSecurityManager(UMOSecurityManager securityManager) throws InitialisationException {
        this.securityManager = securityManager;
        if (securityManager != null && this.isInitialised()) {
            this.securityManager.initialise();
        }
    }

    public UMOSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public UMOWorkManager getWorkManager() {
        return this.workManager;
    }

    public void setWorkManager(UMOWorkManager workManager) {
        if (this.workManager != null) {
            throw new IllegalStateException(CoreMessages.cannotSetObjectOnceItHasBeenSet("workManager").getMessage());
        }
        this.workManager = workManager;
    }

    public QueueManager getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(QueueManager queueManager) {
        this.queueManager = queueManager;
    }
}

