/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.digester.ObjectCreateRule;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.i18n.BuildersMessages;
import org.mule.config.i18n.CoreMessages;
import org.mule.impl.container.ContainerKeyPair;
import org.mule.umo.manager.UMOContainerContext;
import org.xml.sax.Attributes;

public class ObjectGetOrCreateRule
extends ObjectCreateRule {
    public static final String DEFAULT_REF_ATTRIBUTE = "ref";
    public static final String DEFAULT_CLASSNAME_ATTRIBUTE = "className";
    protected String refAttrib = "ref";
    protected String classAttrib = "className";
    protected boolean classRefRequired = false;
    protected String containerMethodName;
    protected UMOContainerContext context;
    protected String containerAttrib;

    public ObjectGetOrCreateRule(String defaultImpl, String className, String containerMethodName) {
        this(defaultImpl, className, DEFAULT_REF_ATTRIBUTE, false, containerMethodName);
    }

    public ObjectGetOrCreateRule(String defaultImpl, String className, boolean classRefRequired, String containerMethodName) {
        this(defaultImpl, className, DEFAULT_REF_ATTRIBUTE, classRefRequired, containerMethodName);
    }

    public ObjectGetOrCreateRule(String defaultImpl, String className, String refAttrib, boolean classRefRequired, String containerMethodName) {
        super(defaultImpl, className);
        this.refAttrib = refAttrib;
        this.classRefRequired = classRefRequired;
        this.containerMethodName = containerMethodName;
    }

    public ObjectGetOrCreateRule(String defaultImpl, String className, String refAttrib, String classAttrib, boolean classRefRequired, String containerMethodName) {
        super(defaultImpl, className);
        this.refAttrib = refAttrib;
        this.classRefRequired = classRefRequired;
        this.containerMethodName = containerMethodName;
        this.classAttrib = classAttrib;
    }

    public ObjectGetOrCreateRule(String defaultImpl, String className, String refAttrib, String containerAttrib, String classAttrib, boolean classRefRequired, String containerMethodName) {
        super(defaultImpl, className);
        this.refAttrib = refAttrib;
        this.containerAttrib = containerAttrib;
        this.classRefRequired = classRefRequired;
        this.containerMethodName = containerMethodName;
        this.classAttrib = classAttrib;
    }

    public void begin(Attributes attributes) throws Exception {
        String ref = attributes.getValue(this.refAttrib);
        String container = null;
        if (this.containerAttrib != null) {
            container = attributes.getValue(this.containerAttrib);
        }
        if (ref != null) {
            Object cRef = ref;
            if (container != null) {
                cRef = new ContainerKeyPair(container, ref);
            }
            Object obj = this.getContainer().getComponent(cRef);
            this.digester.push(obj);
        } else {
            String classRef = attributes.getValue(this.classAttrib);
            if (classRef == null && this.classRefRequired) {
                throw new ConfigurationException(BuildersMessages.mustSpecifyContainerRefOrClassAttribute(this.refAttrib, this.classAttrib, this.digester.getCurrentElementName()));
            }
            super.begin(attributes);
        }
    }

    protected UMOContainerContext getContainer() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (this.context == null) {
            Object root = this.digester.getRoot();
            this.context = (UMOContainerContext)MethodUtils.invokeMethod(root, this.containerMethodName, null);
            if (this.context == null) {
                throw new IllegalArgumentException(CoreMessages.objectIsNull("Container context").toString());
            }
        }
        return this.context;
    }
}

