/*
 * Decompiled with CFR 0.152.
 */
package org.mule.config.builders;

import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.builders.i18n.BuildersMessages;
import org.mule.impl.security.PasswordBasedEncryptionStrategy;
import org.mule.umo.UMOEncryptionStrategy;
import org.mule.util.BeanUtils;
import org.mule.util.ClassUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.TemplateParser;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class PlaceholderProcessor {
    public static final String MULE_ENCRYPTION_PROPERTIES = "org.mule.config.encryption.properties";
    public static final String DEFAULT_ENCRYPTION_PROPERTIES_FILE = "mule-encryption.properties";
    protected static final Log logger = LogFactory.getLog(PlaceholderProcessor.class);
    private static boolean strategiesLoaded = false;
    private final Map types;
    private final Map schemes = new HashMap();
    private final TemplateParser parser = TemplateParser.createAntStyleParser();

    public PlaceholderProcessor() {
        this.types = new HashMap();
        this.types.put("PBE", PasswordBasedEncryptionStrategy.class.getName());
    }

    public PlaceholderProcessor(Map types) {
        this.types = types;
    }

    public Attributes processAttributes(Attributes attributes, String elementName) throws ConfigurationException {
        AttributesImpl attribs = new AttributesImpl(attributes);
        String value = null;
        for (int i = 0; i < attribs.getLength(); ++i) {
            value = attribs.getValue(i);
            if ((value = this.processValue(value)) == null) {
                throw new ConfigurationException(BuildersMessages.propertyTemplateMalformed("<" + elementName + attribs.getLocalName(i) + "='" + value + "' ...>"));
            }
            attribs.setValue(i, value);
        }
        return attribs;
    }

    public String processValue(String value) throws ConfigurationException {
        return this.parser.parse(MuleManager.getInstance().getProperties(), value);
    }

    protected String processEncryptedValue(String value) throws ConfigurationException {
        int x = value.indexOf("{encrypt:");
        if (x > -1) {
            logger.debug("Value contains encrypted data.");
            int y = value.indexOf("}");
            if (y == -1) {
                logger.error("Encryption tag is malformed: " + value);
                return null;
            }
            String scheme = value.substring(x + 9, y);
            logger.debug("look up encryption scheme: " + scheme);
            try {
                UMOEncryptionStrategy strategy = this.getEncryptionStrategy(scheme);
                String data = value.substring(y + 1);
                byte[] decrypted = strategy.decrypt(data.getBytes(), null);
                return new String(decrypted);
            }
            catch (Exception e) {
                throw new ConfigurationException(e);
            }
        }
        return value;
    }

    public UMOEncryptionStrategy getEncryptionStrategy(String scheme) throws Exception {
        if (!strategiesLoaded) {
            this.loadStrategies();
        }
        return (UMOEncryptionStrategy)this.schemes.get(scheme);
    }

    private void loadStrategies() throws Exception {
        String path = System.getProperty(MULE_ENCRYPTION_PROPERTIES, MuleManager.getConfiguration().getWorkingDirectory() + File.separator + DEFAULT_ENCRYPTION_PROPERTIES_FILE);
        logger.info("Attempting to load encryption properties from: " + path);
        Properties props = PropertiesUtils.loadProperties(path, this.getClass());
        HashMap names = new HashMap();
        PropertiesUtils.getPropertiesWithPrefix(props, "name", names);
        Iterator iterator = names.values().iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            Map schemeConfig = new HashMap();
            PropertiesUtils.getPropertiesWithPrefix(props, name + ".", schemeConfig);
            schemeConfig = PropertiesUtils.removeNamespaces(schemeConfig);
            String type = (String)schemeConfig.get("type");
            String clazz = (String)this.types.get(type);
            if (clazz == null) {
                throw new IllegalArgumentException("Unknown encryption type: " + type);
            }
            logger.debug("Found Class: " + clazz + " for type: " + type);
            UMOEncryptionStrategy strat = (UMOEncryptionStrategy)ClassUtils.instanciateClass(clazz, ClassUtils.NO_ARGS, class$org$mule$config$builders$PlaceholderProcessor == null ? PlaceholderProcessor.class$("org.mule.config.builders.PlaceholderProcessor") : class$org$mule$config$builders$PlaceholderProcessor);
            BeanUtils.populateWithoutFail(strat, schemeConfig, true);
            this.schemes.put(name, strat);
        }
    }
}

