/*
 * Decompiled with CFR 0.152.
 */
package org.mule.impl;

import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.CoreMessages;
import org.mule.transformers.codec.Base64Decoder;
import org.mule.transformers.codec.Base64Encoder;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.provider.UMOSessionHandler;
import org.mule.umo.transformer.UMOTransformer;

public class MuleSessionHandler
implements UMOSessionHandler {
    protected transient Log logger = LogFactory.getLog(this.getClass());
    private static UMOTransformer encoder = new Base64Encoder();
    private static UMOTransformer decoder = new Base64Decoder();

    public void retrieveSessionInfoFromMessage(UMOMessage message, UMOSession session) throws UMOException {
        String sessionId = (String)message.removeProperty("MULE_SESSION_ID");
        Object sessionHeader = message.removeProperty("MULE_SESSION");
        if (sessionId != null) {
            throw new IllegalStateException("This session handler does not know how to look up session information for session id: " + sessionId);
        }
        if (sessionHeader != null) {
            String sessionString = null;
            try {
                sessionString = new String((byte[])decoder.transform(sessionHeader), message.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                sessionString = new String((byte[])decoder.transform(sessionHeader));
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Parsing session header: " + sessionString);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(sessionString, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String pair = stringTokenizer.nextToken();
                int i = pair.indexOf("=");
                if (i == -1) {
                    throw new IllegalArgumentException(CoreMessages.sessionValueIsMalformed(pair).toString());
                }
                String name = pair.substring(0, i).trim();
                String value = pair.substring(i + 1).trim();
                session.setProperty(name, value);
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("Added Session variable: " + pair);
            }
        }
    }

    public void storeSessionInfoToMessage(UMOSession session, UMOMessage message) throws UMOException {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getSessionIDKey()).append("=").append(session.getId());
        Iterator iterator = session.getPropertyNames();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            buf.append(";");
            buf.append(o).append("=").append(session.getProperty(o));
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("Adding property to session header: " + o + "=" + session.getProperty(o));
        }
        String sessionString = buf.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Adding session header to message: " + sessionString);
        }
        sessionString = (String)encoder.transform(sessionString);
        message.setProperty("MULE_SESSION", sessionString);
    }

    public String getSessionIDKey() {
        return "ID";
    }
}

