/*
 * Decompiled with CFR 0.152.
 */
package org.mule.routing;

import org.mule.impl.MuleEvent;
import org.mule.impl.RequestContext;
import org.mule.routing.AbstractCatchAllStrategy;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.routing.ComponentRoutingException;
import org.mule.umo.routing.RoutingException;

public class ComponentCatchAllStrategy
extends AbstractCatchAllStrategy {
    public void setEndpoint(UMOEndpoint endpoint) {
        throw new UnsupportedOperationException("The endpoint cannot be set on this catch all");
    }

    public UMOEndpoint getEndpoint() {
        return null;
    }

    public synchronized UMOMessage catchMessage(UMOMessage message, UMOSession session, boolean synchronous) throws RoutingException {
        UMOEvent event = RequestContext.getEvent();
        try {
            event = new MuleEvent(message, event.getEndpoint(), session.getComponent(), event);
            if (synchronous) {
                this.statistics.incrementRoutedMessage(event.getEndpoint());
                this.logger.info("Event being routed from catch all strategy for endpoint: " + RequestContext.getEvent().getEndpoint());
                return session.getComponent().sendEvent(event);
            }
            this.statistics.incrementRoutedMessage(event.getEndpoint());
            session.getComponent().dispatchEvent(event);
            return null;
        }
        catch (UMOException e) {
            throw new ComponentRoutingException(event.getMessage(), event.getEndpoint(), session.getComponent(), (Throwable)e);
        }
    }
}

