/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.simple;

import java.io.Serializable;
import org.apache.commons.lang.SerializationUtils;
import org.mule.transformers.AbstractEventAwareTransformer;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOMessage;
import org.mule.umo.transformer.TransformerException;

public class SerializableToByteArray
extends AbstractEventAwareTransformer {
    public SerializableToByteArray() {
        this.registerSourceType(Serializable.class);
        this.registerSourceType([B.class);
        this.setReturnClass([B.class);
    }

    public boolean isAcceptUMOMessage() {
        return this.isSourceTypeSupported(UMOMessage.class, true);
    }

    public void setAcceptUMOMessage(boolean value) {
        if (value) {
            this.registerSourceType(UMOMessage.class);
        } else {
            this.unregisterSourceType(UMOMessage.class);
        }
    }

    public Object transform(Object src, String encoding, UMOEventContext context) throws TransformerException {
        if (this.isAcceptUMOMessage()) {
            src = context.getMessage();
        } else if (src instanceof byte[]) {
            return src;
        }
        try {
            return SerializationUtils.serialize((Serializable)src);
        }
        catch (Exception e) {
            throw new TransformerException(this, (Throwable)e);
        }
    }
}

