/*
 * Decompiled with CFR 0.152.
 */
package org.mule.umo.security.tls;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.umo.security.tls.TlsConfiguration;
import org.mule.umo.security.tls.TlsPropertiesMapper;

public class TlsPropertiesSocketFactory
extends SSLSocketFactory {
    private Log logger = LogFactory.getLog(this.getClass());
    private boolean anon;
    private String namespace;
    private SSLSocketFactory factory;

    public TlsPropertiesSocketFactory(boolean anon, String namespace) {
        this.logger.debug("creating: " + anon + "; " + namespace);
        this.anon = anon;
        this.namespace = namespace;
    }

    private synchronized SSLSocketFactory getFactory() throws IOException {
        if (null == this.factory) {
            this.logger.debug("creating factory");
            TlsPropertiesMapper propertiesMapper = new TlsPropertiesMapper(this.namespace);
            TlsConfiguration configuration = new TlsConfiguration(".keystore");
            propertiesMapper.readFromProperties(configuration, System.getProperties());
            try {
                configuration.initialise(this.anon, this.namespace);
                this.factory = configuration.getSocketFactory();
            }
            catch (Exception e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        return this.factory;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        return this.getFactory().createSocket(s, host, port, autoClose);
    }

    public String[] getDefaultCipherSuites() {
        try {
            return this.getFactory().getDefaultCipherSuites();
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public String[] getSupportedCipherSuites() {
        try {
            return this.getFactory().getSupportedCipherSuites();
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public Socket createSocket(String arg0, int arg1) throws IOException {
        return this.getFactory().createSocket(arg0, arg1);
    }

    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return this.getFactory().createSocket(arg0, arg1);
    }

    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return this.getFactory().createSocket(arg0, arg1);
    }

    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return this.getFactory().createSocket(arg0, arg1, arg2, arg3);
    }

    public Socket createSocket() throws IOException {
        return this.getFactory().createSocket();
    }
}

