/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.FileUtils;

public final class JarUtils {
    private static final Log logger = LogFactory.getLog(JarUtils.class);

    private JarUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LinkedHashMap readJarFileEntries(File jarFile) throws Exception {
        LinkedHashMap<String, byte[]> entries = new LinkedHashMap<String, byte[]>();
        JarFile jarFileWrapper = null;
        if (jarFile == null) return entries;
        logger.debug("Reading jar entries from " + jarFile.getAbsolutePath());
        try {
            jarFileWrapper = new JarFile(jarFile);
            Enumeration<JarEntry> iter = jarFileWrapper.entries();
            while (iter.hasMoreElements()) {
                ZipEntry zipEntry = iter.nextElement();
                InputStream entryStream = jarFileWrapper.getInputStream(zipEntry);
                ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
                try {
                    IOUtils.copy(entryStream, (OutputStream)byteArrayStream);
                    entries.put(zipEntry.getName(), byteArrayStream.toByteArray());
                    logger.debug("Read jar entry " + zipEntry.getName() + " from " + jarFile.getAbsolutePath());
                }
                finally {
                    byteArrayStream.close();
                }
            }
            Object var9_8 = null;
            if (jarFileWrapper == null) return entries;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (jarFileWrapper == null) throw throwable;
            try {
                jarFileWrapper.close();
                throw throwable;
            }
            catch (Exception ignore) {
                logger.debug(ignore);
            }
            throw throwable;
        }
        try {
            jarFileWrapper.close();
            return entries;
        }
        catch (Exception ignore) {
            logger.debug(ignore);
        }
        return entries;
    }

    public static void appendJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        if (entries != null) {
            LinkedHashMap combinedEntries = JarUtils.readJarFileEntries(jarFile);
            combinedEntries.putAll(entries);
            File tmpJarFile = File.createTempFile(jarFile.getName(), null);
            JarUtils.createJarFileEntries(tmpJarFile, combinedEntries);
            jarFile.delete();
            FileUtils.renameFile(tmpJarFile, jarFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createJarFileEntries(File jarFile, LinkedHashMap entries) throws Exception {
        JarOutputStream jarStream = null;
        FileOutputStream fileStream = null;
        if (jarFile != null) {
            block16: {
                logger.debug("Creating jar file " + jarFile.getAbsolutePath());
                try {
                    fileStream = new FileOutputStream(jarFile);
                    jarStream = new JarOutputStream(fileStream);
                    if (entries != null && !entries.isEmpty()) {
                        Iterator iter = entries.keySet().iterator();
                        while (iter.hasNext()) {
                            String jarFilePath = (String)iter.next();
                            Object content = entries.get(jarFilePath);
                            JarEntry entry = new JarEntry(jarFilePath);
                            jarStream.putNextEntry(entry);
                            logger.debug("Adding jar entry " + jarFilePath + " to " + jarFile.getAbsolutePath());
                            if (content instanceof String) {
                                JarUtils.writeJarEntry((OutputStream)jarStream, ((String)content).getBytes());
                                continue;
                            }
                            if (content instanceof byte[]) {
                                JarUtils.writeJarEntry((OutputStream)jarStream, (byte[])content);
                                continue;
                            }
                            if (!(content instanceof File)) continue;
                            JarUtils.writeJarEntry((OutputStream)jarStream, (File)content);
                        }
                    }
                    jarStream.flush();
                    fileStream.getFD().sync();
                    Object var9_8 = null;
                    if (jarStream == null) break block16;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (jarStream != null) {
                        try {
                            jarStream.close();
                        }
                        catch (Exception jarNotClosed) {
                            logger.debug(jarNotClosed);
                        }
                    }
                    if (fileStream != null) {
                        try {
                            fileStream.close();
                        }
                        catch (Exception fileNotClosed) {
                            logger.debug(fileNotClosed);
                        }
                    }
                    throw throwable;
                }
                try {
                    jarStream.close();
                }
                catch (Exception jarNotClosed) {
                    logger.debug(jarNotClosed);
                }
            }
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (Exception fileNotClosed) {
                    logger.debug(fileNotClosed);
                }
            }
        }
    }

    private static void writeJarEntry(OutputStream stream, byte[] entry) throws IOException {
        stream.write(entry, 0, entry.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeJarEntry(OutputStream stream, File entry) throws IOException {
        FileInputStream fileContentStream = null;
        try {
            fileContentStream = new FileInputStream(entry);
            IOUtils.copy((InputStream)fileContentStream, stream);
            Object var4_3 = null;
            if (fileContentStream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (fileContentStream == null) throw throwable;
            try {
                fileContentStream.close();
                throw throwable;
            }
            catch (Exception fileContentNotClosed) {
                logger.debug(fileContentNotClosed);
            }
            throw throwable;
        }
        try {
            fileContentStream.close();
            return;
        }
        catch (Exception fileContentNotClosed) {
            logger.debug(fileContentNotClosed);
        }
    }
}

