/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.ClassUtils;

public class MuleUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String HANDLER_PKGS_SYSTEM_PROPERTY = "java.protocol.handler.pkgs";
    private static final Log log = LogFactory.getLog(MuleUrlStreamHandlerFactory.class);
    private static Map registry = Collections.synchronizedMap(new HashMap());

    public static synchronized void installUrlStreamHandlerFactory() {
        block2: {
            try {
                URL.setURLStreamHandlerFactory(new MuleUrlStreamHandlerFactory());
            }
            catch (Error err) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Custom MuleUrlStreamHandlerFactory already registered", err);
            }
        }
    }

    public static void registerHandler(String protocol, URLStreamHandler handler) {
        registry.put(protocol, handler);
    }

    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = (URLStreamHandler)registry.get(protocol);
        if (handler == null) {
            handler = this.defaultHandlerCreateStrategy(protocol);
        }
        return handler;
    }

    private URLStreamHandler defaultHandlerCreateStrategy(String protocol) {
        String packagePrefixList = System.getProperty(HANDLER_PKGS_SYSTEM_PROPERTY, "");
        if (!packagePrefixList.endsWith("|")) {
            packagePrefixList = packagePrefixList + "|sun.net.www.protocol";
        }
        StringTokenizer tokenizer = new StringTokenizer(packagePrefixList, "|");
        URLStreamHandler handler = null;
        while (handler == null && tokenizer.hasMoreTokens()) {
            String packagePrefix = tokenizer.nextToken().trim();
            String className = packagePrefix + "." + protocol + ".Handler";
            try {
                handler = (URLStreamHandler)ClassUtils.instanciateClass(className, null);
            }
            catch (Exception ex) {}
        }
        return handler;
    }
}

