/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.concurrent;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ConcurrentHashSet
extends AbstractSet
implements Set,
Serializable {
    private static final long serialVersionUID = 2454657854757543876L;
    private final ConcurrentHashMap map;
    private transient Set keySet;

    public ConcurrentHashSet() {
        this.map = new ConcurrentHashMap();
        this.keySet = this.map.keySet();
    }

    public ConcurrentHashSet(int initialCapacity) {
        this.map = new ConcurrentHashMap(initialCapacity);
        this.keySet = this.map.keySet();
    }

    public ConcurrentHashSet(int initialCapacity, float loadFactor, int concurrencyLevel) {
        this.map = new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
        this.keySet = this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public Iterator iterator() {
        return this.keySet.iterator();
    }

    public Object[] toArray() {
        return this.keySet.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.keySet.toArray(a);
    }

    public boolean add(Object e) {
        return this.map.put(e, Boolean.TRUE) == null;
    }

    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    public boolean removeAll(Collection c) {
        return this.keySet.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.keySet.retainAll(c);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean equals(Object o) {
        return ((Object)this.keySet).equals(o);
    }

    public int hashCode() {
        return ((Object)this.keySet).hashCode();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.keySet = this.map.keySet();
    }
}

