/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.audit;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.audit.InvalidMetricRadical;
import org.ow2.jasmine.monitoring.mbeancmd.audit.Metric;
import org.ow2.jasmine.monitoring.mbeancmd.audit.util.MetricMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCollector {
    private LineNumberReader input_source = null;
    private String separator = ";";
    private String mbeanField = "mbean";
    private int mbeanIndex = -1;
    private String sourceField = "sname";
    private int sourceIndex = -1;
    private String timeField = "time";
    private int timeIndex = -1;
    private boolean isTimeAsLong = true;
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private String header = null;
    private String[] atts = null;
    private int[] attIndex = null;
    private HashMap<String, Metric> baseline = new HashMap();
    private LinkedList<Metric> metrics = new LinkedList();
    private boolean isStatistics = false;
    private ArrayList<HashMap<String, Statistic>> stats = null;

    public FileCollector(InputStream in) {
        this.input_source = new LineNumberReader(new InputStreamReader(in));
    }

    public FileCollector(File file) throws FileNotFoundException {
        this.input_source = new LineNumberReader(new FileReader(file));
    }

    public void scan() {
        boolean goOn = true;
        HashMap<String, Metric> metricMap = new HashMap<String, Metric>();
        while (goOn) {
            try {
                String ln = this.input_source.readLine();
                if (ln == null) {
                    goOn = false;
                    continue;
                }
                if (this.header == null) {
                    this.header = ln;
                    this.processHeader();
                    continue;
                }
                Metric metric = this.parseMetric(ln);
                if (!this.baseline.containsKey(metric.getRadical())) {
                    this.baseline.put(metric.getRadical(), metric);
                }
                metricMap.put(metric.getRadical(), metric);
                if (!this.isStatistics) continue;
                this.updateStatistics(metric);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                goOn = false;
            }
            catch (InvalidHeaderException e) {
                e.printStackTrace(System.err);
                goOn = false;
            }
            catch (ParseException e) {
                e.printStackTrace(System.err);
                goOn = false;
            }
        }
        for (Metric m : metricMap.values()) {
            this.metrics.add(m);
        }
        try {
            this.input_source.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public LinkedList<Metric> getPoll() {
        return this.metrics;
    }

    public HashMap<String, Metric> getBaseline() {
        return this.baseline;
    }

    public LinkedList<Metric> getStats(String attr) {
        LinkedList<Metric> ret = new LinkedList<Metric>();
        HashMap<String, Statistic> stat = null;
        for (int i = 0; i < this.atts.length; ++i) {
            if (!this.atts[i].equals(attr)) continue;
            stat = this.stats.get(i);
            break;
        }
        if (stat != null) {
            for (String key : stat.keySet()) {
                try {
                    Metric m = Metric.newInstance(key);
                    Statistic s = stat.get(key);
                    m.getAttributes().add(new Attribute(attr, new Double(s.average)));
                    m.getAttributes().add(new Attribute("averageNotZero", new Double(s.averageNonZero)));
                    m.getAttributes().add(new Attribute("minNotZero", new Double(s.min)));
                    m.getAttributes().add(new Attribute("max", new Double(s.max)));
                    m.getAttributes().add(new Attribute("timeInterval", new Long(s.time)));
                    m.getAttributes().add(new Attribute("timeNonZero", new Long(s.timeNonZero)));
                    m.getAttributes().add(new Attribute("ratioNonZero", new Double(s.ratioNZ)));
                    ret.add(m);
                }
                catch (InvalidMetricRadical e) {}
            }
        }
        return ret;
    }

    public void setAttributes(String[] attributes) {
        this.atts = (String[])attributes.clone();
        this.attIndex = new int[this.atts.length];
        if (this.isStatistics) {
            this.initStatistics();
        }
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void enableStatistics() {
        this.isStatistics = true;
        this.initStatistics();
    }

    private void initStatistics() {
        if (this.atts != null) {
            this.stats = new ArrayList(this.atts.length);
            for (int i = 0; i < this.atts.length; ++i) {
                this.stats.add(new HashMap());
            }
        }
    }

    private void updateStatistics(Metric m) {
        for (int i = 0; i < this.atts.length; ++i) {
            String mId = m.getRadical();
            Statistic s = this.stats.get(i).get(mId);
            if (s == null) {
                s = new Statistic();
                this.stats.get(i).put(mId, s);
            }
            Attribute a = m.getAttribute(this.atts[i]);
            double d = MetricMath.toDouble(a);
            long t = m.getTimestamp();
            if (s.count == 0) {
                s.t0 = t;
                s.time = 0L;
                s.timeNonZero = 0L;
                s.ratioNZ = 0.0;
                s.sum = 0.0;
                s.average = d;
                s.averageNonZero = d;
                s.min = d;
                s.max = d;
            } else {
                s.time = t - s.t0;
                s.sum += d * (double)(t - s.prevTStamp);
                s.average = s.sum / (double)s.time;
                if (d != 0.0) {
                    s.timeNonZero += t - s.prevTStamp;
                    s.averageNonZero = s.sum / (double)s.timeNonZero;
                }
                if (s.time != 0L) {
                    s.ratioNZ = 1.0 * (double)s.timeNonZero / (double)s.time;
                }
                if (s.min == 0.0 && d > 0.0) {
                    s.min = d;
                }
                if (s.min != 0.0 && d > 0.0 && d < s.min) {
                    s.min = d;
                }
                if (d > s.max) {
                    s.max = d;
                }
            }
            ++s.count;
            s.prevTStamp = t;
        }
    }

    private void processHeader() throws InvalidHeaderException {
        String[] fields = this.header.split(this.separator);
        this.timeIndex = this.fieldIndex(fields, this.timeField);
        this.mbeanIndex = this.fieldIndex(fields, this.mbeanField);
        this.sourceIndex = this.fieldIndex(fields, this.sourceField);
        for (int i = 0; i < this.atts.length; ++i) {
            this.attIndex[i] = this.fieldIndex(fields, this.atts[i]);
        }
    }

    private int fieldIndex(String[] s, String key) throws InvalidHeaderException {
        int ret = -1;
        for (int i = 0; i < s.length; ++i) {
            if (!key.equals(s[i])) continue;
            ret = i;
            break;
        }
        if (ret == -1) {
            throw new InvalidHeaderException("Expected field not found: " + key);
        }
        return ret;
    }

    private Metric parseMetric(String line) throws ParseException {
        String[] tokens = line.split(this.separator);
        long timestamp = this.parseTime(tokens[this.timeIndex]);
        String source = tokens[this.sourceIndex];
        ObjectName on = null;
        try {
            on = ObjectName.getInstance(tokens[this.mbeanIndex]);
        }
        catch (MalformedObjectNameException e) {
            try {
                on = ObjectName.getInstance("nodomain:type=void");
            }
            catch (MalformedObjectNameException e1) {
                // empty catch block
            }
        }
        AttributeList attl = new AttributeList();
        for (int i = 0; i < this.atts.length; ++i) {
            double d = 0.0;
            try {
                d = Double.parseDouble(tokens[this.attIndex[i]]);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            attl.add(new Attribute(this.atts[i], d));
        }
        Metric metric = new Metric(timestamp, source, on, attl);
        return metric;
    }

    private long parseTime(String time) throws ParseException {
        long ret = 0L;
        ret = this.isTimeAsLong ? Long.parseLong(time) : this.simpleDateFormat.parse(time).getTime();
        return ret;
    }

    private class Statistic {
        double max = 0.0;
        double min = 0.0;
        double average = 0.0;
        double averageNonZero = 0.0;
        double sum = 0.0;
        int count = 0;
        long time = 0L;
        long timeNonZero = 0L;
        double ratioNZ = 0.0;
        long prevTStamp = 0L;
        long t0 = 0L;

        private Statistic() {
        }
    }

    private class InvalidHeaderException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidHeaderException(String msg) {
            super(msg);
        }
    }
}

