/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.audit;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashMap;
import javax.management.Attribute;
import org.ow2.jasmine.monitoring.mbeancmd.audit.Metric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricComparator
implements Comparator<Metric> {
    public static final int ASCENDING_ORDER = 1;
    public static final int DESCENDING_ORDER = -1;
    private String attribute = null;
    private int mode = -1;
    private static final HashMap types = new HashMap();

    public MetricComparator(String attr, int mode) {
        this.attribute = attr;
        this.mode = mode;
    }

    @Override
    public int compare(Metric m1, Metric m2) {
        int ret = Integer.MIN_VALUE;
        if (m1 == null) {
            ret = m2 != null ? Integer.MIN_VALUE : 0;
        } else if (m2 == null) {
            ret = Integer.MAX_VALUE;
        } else {
            Attribute a1 = m1.getAttribute(this.attribute);
            Attribute a2 = m2.getAttribute(this.attribute);
            if (a1 == null) {
                ret = a2 != null ? Integer.MIN_VALUE : 0;
            } else if (a2 == null) {
                ret = Integer.MAX_VALUE;
            } else {
                Object v1 = a1.getValue();
                Object v2 = a2.getValue();
                if (MetricComparator.isValid(v1) && MetricComparator.isValid(v2)) {
                    if (v1 == null) {
                        ret = v2 == null ? 0 : Integer.MIN_VALUE;
                    } else if (v2 == null) {
                        ret = Integer.MAX_VALUE;
                    } else {
                        try {
                            Method meth = v1.getClass().getDeclaredMethod("compareTo", v1.getClass());
                            ret = (Integer)meth.invoke(v1, v2);
                            if (ret == 0) {
                                ret = m1.getSource().compareTo(m2.getSource());
                            }
                            if (ret == 0) {
                                ret = m1.getName().toString().compareTo(m2.getName().toString());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
            }
        }
        return ret * this.mode;
    }

    private static boolean isValid(Object obj) {
        return obj == null || obj.getClass().isPrimitive() || types.containsKey(obj.getClass());
    }

    static {
        types.put(Integer.class, Integer.class);
        types.put(Long.class, Long.class);
        types.put(Float.class, Float.class);
        types.put(Double.class, Double.class);
        types.put(String.class, String.class);
        types.put(Boolean.class, Boolean.class);
    }
}

