/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.audit;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.ow2.jasmine.monitoring.mbeancmd.audit.Metric;
import org.ow2.jasmine.monitoring.mbeancmd.audit.MetricComparator;
import org.ow2.jasmine.monitoring.mbeancmd.audit.util.MetricMath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetricSorter {
    private HashMap<String, Metric> baseline = null;

    public void resetBaseline() {
        if (this.baseline != null) {
            this.baseline.clear();
            this.baseline = null;
        }
    }

    public void setBaseline(HashMap<String, Metric> m) {
        this.resetBaseline();
        this.baseline = m;
    }

    public void setBaseline(LinkedList<Metric> l) {
        this.resetBaseline();
        this.baseline = new HashMap();
        for (Metric m : l) {
            this.baseline.put(m.getRadical(), m);
        }
    }

    public TreeSet<Metric> sort(LinkedList<Metric> metrics, String attribute) {
        return this.sort(metrics, attribute, -1);
    }

    public TreeSet<Metric> sort(LinkedList<Metric> metrics, String attribute, int sortMode) {
        LinkedList<Metric> delta = metrics;
        if (this.baseline != null) {
            delta = new LinkedList();
            for (Metric m : metrics) {
                Metric b;
                Metric r = Metric.delta(m, b = this.baseline.get(m.getRadical()), attribute);
                if (r == null) continue;
                delta.add(r);
            }
        }
        TreeSet<Metric> tset = new TreeSet<Metric>(new MetricComparator(attribute, sortMode));
        tset.addAll(delta);
        return tset;
    }

    public static void printMetrics(PrintStream pout, TreeSet<Metric> tset, String attribute) {
        MetricSorter.printMetrics(pout, tset, attribute, false, false);
    }

    public static void printMetrics(PrintStream pout, TreeSet<Metric> tset, String attribute, boolean printZeroValue) {
        MetricSorter.printMetrics(pout, tset, attribute, printZeroValue, false);
    }

    public static void printMetrics(PrintStream pout, TreeSet<Metric> tset, String attribute, boolean printZeroValue, boolean printStats) {
        DecimalFormat df = new DecimalFormat("####.#", new DecimalFormatSymbols(Locale.ENGLISH));
        String[] atts = MetricSorter.getAttributeNames(tset.first(), attribute);
        if (atts == null) {
            return;
        }
        pout.print(attribute + ";range;source;mbean");
        if (printStats) {
            for (int i = 1; i < atts.length; ++i) {
                pout.print(";" + atts[i]);
            }
        }
        pout.println();
        for (Metric m : tset) {
            Attribute att = m.getAttribute(attribute);
            boolean printable = printZeroValue || MetricMath.isNonZero(att);
            if (!printable) continue;
            double range = MetricMath.range(MetricMath.toDouble(att));
            pout.print(att.getValue() + ";" + df.format(range) + ";" + m.getSource() + ";" + m.getName());
            if (printStats) {
                for (int i = 1; i < atts.length; ++i) {
                    pout.print(";" + m.getAttribute(atts[i]).getValue());
                }
            }
            pout.println();
        }
    }

    private static String[] getAttributeNames(Metric m, String attribute) {
        String[] atts = null;
        Attribute att = m.getAttribute(attribute);
        if (att != null) {
            AttributeList l = m.getAttributes();
            atts = new String[l.size()];
            int n = 0;
            atts[n++] = attribute;
            Iterator it = l.iterator();
            while (it.hasNext()) {
                String attName = ((Attribute)it.next()).getName();
                if (attName.equals(attribute)) continue;
                atts[n++] = attName;
            }
        }
        return atts;
    }
}

