/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.CpuSunSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.DSSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.EntitySampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.JCACFSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.JoramQSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SFBSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SLBSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.ServerSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.ServletSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.TxSampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.WebSampler;

public class SamplerFactory {
    protected SamplerFactory() {
    }

    public static Sampler newSampler(String type, String onPattern, SamplerContext context) {
        Sampler sampler = null;
        if ("web".equals(type)) {
            sampler = new WebSampler(context);
        }
        if ("tx".equals(type)) {
            sampler = new TxSampler(context);
        }
        if ("cpusun".equals(type)) {
            sampler = new CpuSunSampler(context);
        }
        if ("server".equals(type)) {
            sampler = new ServerSampler(context);
        }
        if ("datasource".equals(type)) {
            sampler = new DSSampler(context);
        }
        if ("jcacf".equals(type)) {
            sampler = new JCACFSampler(context);
        }
        if ("servlet".equals(type)) {
            sampler = new ServletSampler(context);
        }
        if ("stateless".equals(type)) {
            sampler = new SLBSampler(context);
        }
        if ("stateful".equals(type)) {
            sampler = new SFBSampler(context);
        }
        if ("entity".equals(type)) {
            sampler = new EntitySampler(context);
        }
        if ("joramQueue".equals(type)) {
            sampler = new JoramQSampler(context);
        }
        sampler.setOnPattern(onPattern);
        return sampler;
    }
}

