/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.HashMap;
import java.util.Map;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerData
extends SampleData {
    private double httpRate = 0.0;
    private double cnxRate = 0.0;
    private double txRate = 0.0;
    private long currentTotalMemory = 0L;
    private long currentUsedMemory = 0L;
    private int threadsGauge = 0;
    private long nbSessions = 0L;
    private long pendingHttpRequest = 0L;
    private long httpRequestCount = 0L;
    private long httpErrorCount = 0L;
    private long pendingTxGauge = 0L;
    private long txCommitedCount = 0L;
    private long txRollbackCount = 0L;
    private int dsCnxGauge = 0;
    private int dsCnxbusy = 0;
    private int dsOpenFailures = 0;
    private int dsRejectedOpen = 0;
    private int dsLeaks = 0;
    private int dsWaits = 0;
    private int dsServed = 0;
    private int entCacheNb = 0;
    private int entPoolNb = 0;
    private int ssbCacheNb = 0;
    private int ssbPoolNb = 0;
    private long ssbCallsNb = 0L;
    private int sfbCacheNb = 0;
    private int sfbPoolNb = 0;
    private static String header = "threads;heap;usedHeap;sessions;pendingHttp;pendingTx;dsCnx;dsCnxBusy;httpRate;txRate;dsRate;dsFails;dsWaits;dsRejects;dsLeaks;httpErrs;rollbacks;entityCache;entityFreePool;ssbCache;ssbFreePool;ssbCalls;sfbCache;sfbFreePool";

    @Override
    public void compute(SampleData needs_cast) {
        ServerData prev = (ServerData)needs_cast;
        if (prev != null) {
            double sampleTime = this.computeSamplePeriod(prev);
            this.httpRate = (double)(this.getHttpRequests() - prev.getHttpRequests()) / sampleTime;
            this.txRate = (double)(this.getCommitedTx() - prev.getCommitedTx()) / sampleTime;
            this.cnxRate = (double)(this.dsServed - prev.dsServed) / sampleTime;
        } else {
            this.httpRate = 0.0;
            this.txRate = 0.0;
            this.cnxRate = 0.0;
        }
    }

    @Override
    protected String getInnerPrintHeader() {
        return header.replaceAll(";", ServerData.getSeparator());
    }

    @Override
    protected String getInnerPrintData() {
        return this.getThreads() + ServerData.getSeparator() + this.getMemory() + ServerData.getSeparator() + this.getUsedMemory() + ServerData.getSeparator() + this.getSessions() + ServerData.getSeparator() + this.getPendingHttp() + ServerData.getSeparator() + this.getPendingTx() + ServerData.getSeparator() + this.getDSCnx() + ServerData.getSeparator() + this.getDSCnxBusy() + ServerData.getSeparator() + decimalFormat.format(this.getHttpRate()) + ServerData.getSeparator() + decimalFormat.format(this.getTxRate()) + ServerData.getSeparator() + decimalFormat.format(this.getCnxRate()) + ServerData.getSeparator() + this.getDSFails() + ServerData.getSeparator() + this.getDSWaits() + ServerData.getSeparator() + this.getDSRejects() + ServerData.getSeparator() + this.getDSLeaks() + ServerData.getSeparator() + this.getHttpErrors() + ServerData.getSeparator() + this.getRollbackTx() + ServerData.getSeparator() + this.getEntityCacheNb() + ServerData.getSeparator() + this.getEntityPoolNb() + ServerData.getSeparator() + this.getSsbCacheNb() + ServerData.getSeparator() + this.getSsbPoolNb() + ServerData.getSeparator() + this.getSsbCallsNb() + ServerData.getSeparator() + this.getSfbCacheNb() + ServerData.getSeparator() + this.getSfbPoolNb();
    }

    @Override
    public Map<String, ?> getValueOfAttributes() {
        HashMap<String, Number> valueOfAttributes = new HashMap<String, Number>();
        valueOfAttributes.put("threads", this.threadsGauge);
        valueOfAttributes.put("heap", this.currentTotalMemory);
        valueOfAttributes.put("usedHeap", this.currentUsedMemory);
        valueOfAttributes.put("sessions", this.nbSessions);
        valueOfAttributes.put("pendingHttp", this.pendingHttpRequest);
        valueOfAttributes.put("pendingTx", this.pendingTxGauge);
        valueOfAttributes.put("dsCnx", this.dsCnxGauge);
        valueOfAttributes.put("dsCnxBusy", this.dsCnxbusy);
        valueOfAttributes.put("httpRate", this.httpRate);
        valueOfAttributes.put("txRate", this.txRate);
        valueOfAttributes.put("dsRate", this.cnxRate);
        valueOfAttributes.put("dsFails", this.dsOpenFailures);
        valueOfAttributes.put("dsWaits", this.dsWaits);
        valueOfAttributes.put("dsRejects", this.dsRejectedOpen);
        valueOfAttributes.put("dsLeaks", this.dsLeaks);
        valueOfAttributes.put("httpErrs", this.httpErrorCount);
        valueOfAttributes.put("rollbacks", this.txRollbackCount);
        valueOfAttributes.put("entityCache", this.entCacheNb);
        valueOfAttributes.put("entityFreePool", this.entPoolNb);
        valueOfAttributes.put("ssbCache", this.ssbCacheNb);
        valueOfAttributes.put("ssbFreePool", this.ssbPoolNb);
        valueOfAttributes.put("ssbCalls", this.ssbCallsNb);
        valueOfAttributes.put("sfbCache", this.sfbCacheNb);
        valueOfAttributes.put("sfbFreePool", this.sfbPoolNb);
        return valueOfAttributes;
    }

    public double getHttpRate() {
        return this.httpRate;
    }

    public double getCnxRate() {
        return this.cnxRate;
    }

    public double getTxRate() {
        return this.txRate;
    }

    public void setMemory(long mem) {
        this.currentTotalMemory = mem;
    }

    public long getMemory() {
        return this.currentTotalMemory;
    }

    public void setUsedMemory(long mem) {
        this.currentUsedMemory = mem;
    }

    public long getUsedMemory() {
        return this.currentUsedMemory;
    }

    public void setThreads(int th) {
        this.threadsGauge = th;
    }

    public int getThreads() {
        return this.threadsGauge;
    }

    public void setSessions(long sess) {
        this.nbSessions = sess;
    }

    public long getSessions() {
        return this.nbSessions;
    }

    public void setPendingHttp(long req) {
        this.pendingHttpRequest = req;
    }

    public long getPendingHttp() {
        return this.pendingHttpRequest;
    }

    public void setHttpRequests(long req) {
        this.httpRequestCount = req;
    }

    public long getHttpRequests() {
        return this.httpRequestCount;
    }

    public void setHttpErrors(long req) {
        this.httpErrorCount = req;
    }

    public long getHttpErrors() {
        return this.httpErrorCount;
    }

    public void setPendingTx(long tx) {
        this.pendingTxGauge = tx;
    }

    public long getPendingTx() {
        return this.pendingTxGauge;
    }

    public void setCommitedTx(long tx) {
        this.txCommitedCount = tx;
    }

    public long getCommitedTx() {
        return this.txCommitedCount;
    }

    public void setRollbackTx(long tx) {
        this.txRollbackCount = tx;
    }

    public long getRollbackTx() {
        return this.txRollbackCount;
    }

    public void setDSCnx(int cnx) {
        this.dsCnxGauge = cnx;
    }

    public int getDSCnx() {
        return this.dsCnxGauge;
    }

    public void setDSCnxBusy(int cnx) {
        this.dsCnxbusy = cnx;
    }

    public int getDSCnxBusy() {
        return this.dsCnxbusy;
    }

    public void setDSFails(int cnx) {
        this.dsOpenFailures = cnx;
    }

    public int getDSFails() {
        return this.dsOpenFailures;
    }

    public void setDSRejects(int rj) {
        this.dsRejectedOpen = rj;
    }

    public int getDSRejects() {
        return this.dsRejectedOpen;
    }

    public void setDSLeaks(int lk) {
        this.dsLeaks = lk;
    }

    public int getDSLeaks() {
        return this.dsLeaks;
    }

    public void setDSWaits(int w) {
        this.dsWaits = w;
    }

    public int getDSWaits() {
        return this.dsWaits;
    }

    public int getDSServed() {
        return this.dsServed;
    }

    public void setDSServed(int dsServed) {
        this.dsServed = dsServed;
    }

    public void setEntityCacheNb(int nb) {
        this.entCacheNb = nb;
    }

    public int getEntityCacheNb() {
        return this.entCacheNb;
    }

    public void setEntityPoolNb(int nb) {
        this.entPoolNb = nb;
    }

    public int getEntityPoolNb() {
        return this.entPoolNb;
    }

    public void setSsbCacheNb(int nb) {
        this.ssbCacheNb = nb;
    }

    public int getSsbCacheNb() {
        return this.ssbCacheNb;
    }

    public void setSsbPoolNb(int nb) {
        this.ssbPoolNb = nb;
    }

    public int getSsbPoolNb() {
        return this.ssbPoolNb;
    }

    public long getSsbCallsNb() {
        return this.ssbCallsNb;
    }

    public void setSsbCallsNb(long ssbCallsNb) {
        this.ssbCallsNb = ssbCallsNb;
    }

    public void setSfbCacheNb(int nb) {
        this.sfbCacheNb = nb;
    }

    public int getSfbCacheNb() {
        return this.sfbCacheNb;
    }

    public void setSfbPoolNb(int nb) {
        this.sfbPoolNb = nb;
    }

    public int getSfbPoolNb() {
        return this.sfbPoolNb;
    }
}

