/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.monitoring.mbeancmd.sampling;

import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.ow2.jasmine.monitoring.mbeancmd.context.SamplerContext;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.SampleData;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.Sampler;
import org.ow2.jasmine.monitoring.mbeancmd.sampling.TxData;

public class TxSampler
extends Sampler {
    private boolean refreshable = false;

    public TxSampler(SamplerContext context) {
        super(context);
    }

    public String getDefaultOnPattern() {
        return "*:j2eeType=JTAResource,*";
    }

    protected SampleData newSampleData() {
        return new TxData();
    }

    protected SampleData poll(SampleData data) {
        this.pollJTM((TxData)data);
        return data;
    }

    private void pollJTM(TxData data) {
        ObjectName[] oNames;
        long txCount = 0L;
        long currentTxGauge = 0L;
        long rolledbackTx = 0L;
        long timedOutTx = 0L;
        AttributeList al = null;
        MBeanServerConnection cnx = null;
        String[] attIds = new String[]{"totalCurrentTransactions", "totalCommittedTransactions", "totalRolledbackTransactions", "totalExpiredTransactions"};
        try {
            oNames = this.getRefreshedJTAONames();
        }
        catch (Exception e) {
            return;
        }
        if (oNames != null) {
            for (int i = 0; i < oNames.length; ++i) {
                try {
                    cnx = this.getMBeanServerConnection();
                    al = cnx.getAttributes(oNames[i], attIds);
                    this.releaseMbeanServerConnection();
                    cnx = null;
                    Iterator it = al.iterator();
                    Attribute att = (Attribute)it.next();
                    currentTxGauge += Long.parseLong(att.getValue().toString());
                    att = (Attribute)it.next();
                    txCount += Long.parseLong(att.getValue().toString());
                    att = (Attribute)it.next();
                    rolledbackTx += Long.parseLong(att.getValue().toString());
                    att = (Attribute)it.next();
                    timedOutTx += Long.parseLong(att.getValue().toString());
                    data.setValid(true);
                    continue;
                }
                catch (Exception e) {
                    this.refreshable = true;
                    data.setValid(false);
                    System.err.println("Error on mbean " + oNames[i] + " for " + this.context.getName());
                    e.printStackTrace(System.err);
                }
            }
            data.setCommittedTxCnt(txCount);
            data.setRolledbackTxCnt(rolledbackTx);
            data.setPendingTxGauge(currentTxGauge);
            data.setTimedOutTxCnt(timedOutTx);
            data.setServerInfo(this.getName(), this.getJmxUrl(), this.getServer(), this.getDomain());
            if (oNames.length > 0) {
                data.setObjectName(oNames[0]);
            }
        }
    }

    private ObjectName[] getRefreshedJTAONames() throws Exception {
        ObjectName[] oNames = null;
        Set<ObjectName> son = this.context.getOnames();
        if (son == null) {
            this.refreshable = true;
        }
        if (this.refreshable) {
            oNames = this.queryON(this.getOnPattern());
            if (oNames != null) {
                this.refreshable = false;
            }
        } else if (son != null && !son.isEmpty()) {
            oNames = son.toArray(new ObjectName[son.size()]);
        }
        return oNames;
    }
}

