@Echo Off

Rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Rem - JASMINe
Rem - Copyright (C) 2008-2009 Bull S.A.S.
Rem - Contact: jasmine@ow2.org
Rem -
Rem - This library is free software; you can redistribute it and/or
Rem - modify it under the terms of the GNU Lesser General Public
Rem - License as published by the Free Software Foundation; either
Rem - version 2.1 of the License, or any later version.
Rem -
Rem - This library is distributed in the hope that it will be useful,
Rem - but WITHOUT ANY WARRANTY; without even the implied warranty of
Rem - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Rem - Lesser General Public License for more details.
Rem -
Rem - You should have received a copy of the GNU Lesser General Public
Rem - License along with this library; if not, write to the Free Software
Rem - Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
Rem - USA
Rem -
Rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Rem - $Id: generate-ra.bat 6218 2010-03-29 08:25:18Z alitokmen $
Rem - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
Rem
Rem

set JONAS_ROOT=%{INSTALL_PATH}\jonas_root
set JONAS_BASE=%{INSTALL_PATH}

JMXCONNEXIONPOOL_DIR=%{INSTALL_PATH}\JMX_connection_pool_adapter

echo #############################################################################################
echo #
echo #
echo #                              JMXConnection RA Building tool"
echo #
echo #

set DEPLOYDIR=""
set DEPLOY=false
set RACONFIG=""
set JNDINAME="service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas"
set FILEPROPERTY=JMXCONNEXIONPOOL_DIR\jmxconnectionra.properties
set INPUTFILE=""
set OUTPUTFILE=%JMXCONNEXIONPOOL_DIR%\generated\JMXGeneratedRA.rar
set LEGACY=false
set RAR_NAME=%JMXCONNEXIONPOOL_DIR%\jmxadapter_for_jonas
set RAR_VERSION=

set MINCONPOOL=0
set MAXCONPOOL=2
set CONMAXAGE=1
set MAXOPENTIME=1
set MAXWAITERS=500
set MAXWAITTIME=10


Rem Test JONAS_ROOT and JONAS_BASE
if ["%JONAS_ROOT%"]==[""] goto set_jonas_root
if ["%JONAS_BASE%"]==[""] goto set_jonas_base
goto :parsing

:set_jonas_root
echo # 
echo #   Check that JONAS_ROOT is set
echo #
echo #############################################################################################
goto :EOF

:set_jonas_base
set JONAS_BASE=%JONAS_ROOT%


goto parsing

:help
  echo #   This script helps to generate new RA from the JMXConnectionRA. It uses RAConfig.
  echo #
  echo #   Options :
  echo #
  echo #        -h Print this help message
  echo #        -l This option has to be set if running on JOnAS 4.8.6, 4.9.2, 5.0.3 or older versions.
  echo #        -j ^<JNDIName^> Set the JMX URL of server you want to connect to
  echo #            example :
  echo #                service:jmx:rmi:///jndi/rmi://localhost:1099/jrmpconnector_jonas
  echo #
  echo #        -p ^<minconpool^> ^<maxconpool^> ^<conmaxage^> ^<maxopentime^> ^<maxwaiters^> ^<maxwaittime^> 
  echo #             Specify properties to build the RA.
  echo #             Default values are 0 2 1 1 500 10. 
  echo #             These properties are used to configure the RA pool. 
  echo #                    
  echo #        -o ^<outputFileName^> Specify the output file name of the ra. default value is
  echo #                    JMXGeneratedRA. The .rar extension is automatically set.
  echo #        -d If this option is set, the generated RA will be moved into the JONAS_BASE
  echo #                    deploy directory.
  echo #
  echo #############################################################################################
goto :EOF


Rem Parse command line

:parsing

:loop_on_args
if ["%1"] == ["-j"] goto j_arg
if ["%1"] == ["-p"] goto p_arg
if ["%1"] == ["-o"] goto o_arg
if ["%1"] == ["-d"] goto d_arg
if ["%1"] == ["-l"] goto l_arg
if ["%1"] == ["-h"] goto h_arg
if ["%1"] == []     goto help
if ["%1"] == [""]   goto help
goto next_arg

:j_arg
set JNDINAME=%2
shift
goto next_arg

:p_arg
set MINCONPOOL=%2
set MAXCONPOOL=%3
set CONMAXAGE=%4
set MAXOPENTIME=%5
set MAXWAITERS=%6
set MAXWAITTIME=%7
shift
goto next_arg

:o_arg
set OUTPUTFILE=%2.rar
shift
goto next_arg

:d_arg
set DEPLOY=true
goto next_arg

:l_arg
set LEGACY=true
goto next_arg

:h_arg
goto help

:next_arg
shift
if not ["%1"]==[""] goto loop_on_args

:jndi_match
set JNDINAME=%JNDINAME::=_%
set JNDINAME=%JNDINAME:/=_%

Rem Set input file

if not exist "%RAR_NAME%.rar" goto dist
set INPUTFILE="%RAR_NAME%.rar"
goto end_input_file

:dist
if not exist "%RAR_NAME%.rar" goto input_file_error
set INPUTFILE="%RAR_NAME%.rar"
goto end_input_file

:input_file_error
echo #
echo #   you need to compile the RA and deploy it first 
echo #
echo #############################################################################################
goto :EOF

:end_input_file

echo #
echo #   Use the following input file :
echo #   %INPUTFILE%
echo #

Rem Set deploy directory and RAConfig path

if not exist %JONAS_BASE%\deploy goto deploy_dir_error 
set DEPLOYDIR=%JONAS_BASE%\deploy
goto end_deploy_dir_exists
  
:deploy_dir_error
echo #
echo #   A problem occured when trying to get the deploy directory. 
echo #   Check that JONAS_BASE is set
echo #
echo #############################################################################################
goto :EOF

:end_deploy_dir_exists

if not exist %JONAS_ROOT%\bin\RAConfig.bat goto raconfig_dir_error 
set RACONFIG=%JONAS_ROOT%\bin\RAConfig.bat
goto end_raconfig_exists

:raconfig_dir_error
echo #
echo #   A problem occured when trying to get the RAConfig script.
echo #   Check that JONAS_ROOT is set
echo #
echo #############################################################################################
goto :EOF

:end_raconfig_exists

echo #
echo #   Generating RA ...
echo #

if ["%LEGACY%"]==["true"] goto legacy_true
%RACONFIG% -NEW -r JMXConnectionRA -jndiname %JNDINAME% -p %FILEPROPERTY% %INPUTFILE% %OUTPUTFILE%
goto end_generation

:legacy_true
set TMP_DIR=tmp\jmxRA
set META_INF_DIR=%TMP_DIR%\META-INF

if not exist [%META_INF_DIR%] MKDIR %META_INF_DIR%

(
echo ^<?xml version=^"1.0^"?^>
echo ^<jonas-connector xmlns=^"http://www.objectweb.org/jonas/ns^"
echo               xmlns:xsi=^"http://www.w3.org/2001/XMLSchema-instance^"
echo               xsi:schemaLocation=^"http://www.objectweb.org/jonas/ns
echo               http://www.objectweb.org/jonas/ns/jonas-connector_4_4.xsd^" ^>
echo ^<rarlink^>JMXConnectionRA^</rarlink^>
echo  ^<native-lib^>^</native-lib^>
echo  ^<log-enabled^>false^</log-enabled^>
echo ^<log-topic^>^</log-topic^>
echo  ^<pool-params^>
echo    ^<pool-init^>0^</pool-init^>
echo    ^<pool-min^>%MINCONPOOL%^</pool-min^>
echo    ^<pool-max^>%MAXCONPOOL%^</pool-max^>
echo    ^<pool-max-age-minutes^>%CONMAXAGE%^</pool-max-age-minutes^>
echo    ^<pstmt-max^>10^</pstmt-max^>
echo    ^<pool-max-opentime^>%MAXOPENTIME%^</pool-max-opentime^>
echo    ^<pool-max-waiters^>%MAXWAITERS%^</pool-max-waiters^>
echo    ^<pool-max-waittime^>%MAXWAITTIME%^</pool-max-waittime^>
echo    ^<pool-sampling-period^>30^</pool-sampling-period^>
echo  ^</pool-params^>
echo ^<jdbc-conn-params^>
echo    ^<jdbc-check-level^>0^</jdbc-check-level^>
echo  ^</jdbc-conn-params^>
echo  ^<jonas-connection-definition^>
echo    ^<description^>org.ow2.jasmine.adapter.jmx.pool.outbound.ManagedConnectionFactoryImpl^</description^>
echo    ^<jndi-name^>%JNDINAME%^</jndi-name^>
echo  ^</jonas-connection-definition^>
echo ^</jonas-connector^>
) > %META_INF_DIR%\jonas-ra.xml

 
Rem Make the rar file
 
jar -cf %OUTPUTFILE% -C %TMP_DIR% META-INF
RMDIR /S/Q %TMP_DIR%

:end_generation

if ["%DEPLOY%"]==["false"] goto :not_moved
Rem Move the RA in the deploy directory
MOVE %OUTPUTFILE% %DEPLOYDIR%

echo #
echo #    RA generated and moved into the deploy directory
echo #
echo #   Summary :
echo #      Property file used : %FILEPROPERTY%
echo #      RAConfig : %RACONFIG%
echo #      JNDIName : %JNDINAME%
echo #      Output file : %OUTPUTFILE%
echo #      Deploy dir : %DEPLOYDIR%
goto end

:not_moved
echo #
echo #   RA generated ...
echo #
echo #   Summary : 
echo #      Property file used : %FILEPROPERTY%
echo #      RAConfig : %RACONFIG%
echo #      JNDIName : %JNDINAME%
echo #      Output file : %OUTPUTFILE%
echo #      Deploy dir : RA not deployed, %OUTPUTFILE% is in the current directory
echo #

:end
echo #
echo #############################################################################################


