#!/bin/sh

export JAVA_HOME=${JAVA_HOME}

export JONAS_ROOT=${INSTALL_PATH}/jonas-root
export JONAS_BASE=${INSTALL_PATH}

# Check if $JONAS_ROOT is set.
if [ -z "$JONAS_ROOT" ]; then
    echo Please set the JONAS_ROOT variable.
    exit
fi

# Check if $JONAS_BASE is set.
if [ -z "$JONAS_BASE" ]; then
    JONAS_BASE=$JONAS_ROOT
fi


export PATH=$JONAS_ROOT/bin:$PATH

echo $JONAS_ROOT
echo $JONAS_BASE

# ---------------------------------------------
# Get arguments
# ---------------------------------------------
ARGS=

case "$1" in
  start)
    jonas start -n jasmine-monitoring -clean -fg -Djonas.felix.configuration.file=conf/config.properties -Dcom.sun.management.jmxremote
    ;;
  stop)
    jonas admin -n jasmine-monitoring -r "$JONAS_BASE/deploy/zz_jasmine-monitoring.xml"
    jonas stop -n jasmine-monitoring
    ;;
  *)
    echo "usage : jasmine start | stop"
esac
