/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.validation.hibernate;

import javax.validation.spi.ValidationProvider;
import org.hibernate.validator.HibernateValidator;
import org.hibernate.validator.HibernateValidatorConfiguration;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.J2EEServerService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JOnASHibernateValidationServiceImpl
extends AbsServiceImpl {
    private static Log logger = LogFactory.getLog(JOnASHibernateValidationServiceImpl.class);
    private ValidationProvider<HibernateValidatorConfiguration> validationProvider = null;
    private JmxService jmxService = null;
    private BundleContext bundleContext = null;
    private ServiceRegistration validationServiceRegistration = null;
    private J2EEServerService j2eeServer = null;

    public JOnASHibernateValidationServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.validationProvider = new HibernateValidator();
    }

    protected void doStart() throws ServiceException {
        this.jmxService.loadDescriptors(((Object)((Object)this)).getClass().getPackage().getName(), ((Object)((Object)this)).getClass().getClassLoader());
        try {
            this.jmxService.registerModelMBean((Object)this, JonasObjectName.validationService((String)this.getDomainName()));
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot register MBean for validation service", new Object[]{e});
        }
        if (this.validationServiceRegistration == null) {
            this.validationServiceRegistration = this.bundleContext.registerService(ValidationProvider.class.getName(), this.validationProvider, null);
        }
    }

    protected void doStop() throws ServiceException {
        try {
            this.jmxService.unregisterModelMBean(JonasObjectName.validationService((String)this.getDomainName()));
        }
        catch (Exception e) {
            logger.debug((Object)"Cannot unregister MBean for validation service", new Object[]{e});
        }
        if (this.validationServiceRegistration != null) {
            this.validationServiceRegistration.unregister();
            this.validationServiceRegistration = null;
        }
    }

    public void setJmxService(JmxService jmxService) {
        this.jmxService = jmxService;
    }

    public void setJ2EEServer(J2EEServerService j2eeServer) {
        this.j2eeServer = j2eeServer;
    }
}

