/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.jetty6;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.handler.RequestLogHandler;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.xml.XmlConfiguration;
import org.objectweb.util.monolog.api.BasicLevel;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.web.JWebContainerService;
import org.ow2.jonas.web.JWebContainerServiceException;
import org.ow2.jonas.web.base.BaseWebContainerService;

public class Jetty6Service
extends BaseWebContainerService
implements JWebContainerService {
    private static final String JETTY_CONFIGURATION_FILE = BaseWebContainerService.JONAS_BASE + File.separator + "conf" + File.separator + "jetty6.xml";
    private static final String JETTY_DEFAULT_WEB_XML_FILE = BaseWebContainerService.JONAS_BASE + File.separator + "conf" + File.separator + "jetty6-web.xml";
    private static String config = null;
    private Server server = null;
    private DefaultHandler defaultHandler = null;
    private RequestLogHandler requestLogHandler = null;
    private ContextHandlerCollection webAppContexts = null;
    private HandlerCollection handlers;

    private void initHandlers() {
        this.defaultHandler = new DefaultHandler();
        this.requestLogHandler = new RequestLogHandler();
        this.webAppContexts = new ContextHandlerCollection();
        this.handlers = new HandlerCollection();
        this.handlers.setHandlers(new Handler[]{this.webAppContexts, this.defaultHandler, this.requestLogHandler});
        this.server.setHandler((Handler)this.handlers);
    }

    public void doStart() throws ServiceException {
        if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)"");
        }
        config = JETTY_CONFIGURATION_FILE;
        Jetty6Service.getLogger().log(BasicLevel.LEVEL_DEBUG, (Object)("Using configuration file " + config));
        this.server = new Server();
        this.initHandlers();
        if (this.server != null) {
            if (config != null) {
                IExecution<Server> jettyServerConfiguration = new IExecution<Server>(){

                    public Server execute() throws Exception {
                        XmlConfiguration configuration = new XmlConfiguration(new File(config).toURL());
                        configuration.configure((Object)Jetty6Service.this.server);
                        Jetty6Service.this.server.start();
                        return Jetty6Service.this.server;
                    }
                };
                ExecutionResult result = RunnableHelper.execute((ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (IExecution)jettyServerConfiguration);
                if (result.hasException()) {
                    Jetty6Service.getLogger().log(BasicLevel.LEVEL_ERROR, (Object)("Error has occured while starting Jetty server using configuration file " + config), (Throwable)result.getException());
                }
            }
        } else {
            throw new ServiceException("Cannot start Jetty server.");
        }
        super.doStart();
        Jetty6Service.getLogger().log(BasicLevel.INFO, (Object)"Jetty6 Service started");
    }

    protected void doStop() throws ServiceException {
        super.doStop();
        if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)"");
        }
        if (this.isStarted() && this.server != null) {
            try {
                this.server.stop();
                this.server.destroy();
                this.server = null;
                Jetty6Service.getLogger().log(BasicLevel.INFO, (Object)"Jetty6 Service stopped");
            }
            catch (Exception eExc) {
                Jetty6Service.getLogger().log(BasicLevel.LEVEL_ERROR, (Object)("error has occured while stopping Jetty server using configuration file " + config), (Throwable)eExc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void doRegisterWar(Context ctx) throws JWebContainerServiceException {
        unpackedWarURL = null;
        contextRoot = null;
        java2DelegationModel = true;
        try {
            unpackedWarURL = (URL)ctx.lookup("unpackedWarURL");
            contextRoot = (String)ctx.lookup("contextRoot");
            bool = (Boolean)ctx.lookup("java2DelegationModel");
            java2DelegationModel = bool;
        }
        catch (NamingException e) {
            err = "Error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        webClassLoader = null;
        try {
            webClassLoader = (ClassLoader)ctx.lookup("parentCL");
        }
        catch (NamingException e) {
            err = "error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        hostName = null;
        try {
            hostName = (String)ctx.lookup("hostName");
        }
        catch (NamingException e) {
            hostName = "";
        }
        earAppName = null;
        try {
            earAppName = (String)ctx.lookup("earAppName");
        }
        catch (NamingException e) {
            earAppName = null;
        }
        if (contextRoot.equals("/")) {
            contextRoot = "";
        } else if (contextRoot.equalsIgnoreCase("ROOT")) {
            contextRoot = "";
        }
        fWar = new File(unpackedWarURL.getFile());
        fileName = fWar.getAbsolutePath();
        if (this.server != null) {
            try {
                webAppContext = new WebAppContext();
                webAppContext.setContextPath("/" + contextRoot);
                webAppContext.setWar(unpackedWarURL.toString());
                if (hostName != null && hostName.length() > 0) {
                    webAppContext.setConnectorNames(new String[]{hostName});
                }
                webAppContext.setAttribute("J2EEDomainName", (Object)this.getDomainName());
                webAppContext.setAttribute("J2EEServerName", (Object)this.getJonasServerName());
                webAppContext.setAttribute("J2EEApplicationName", (Object)earAppName);
                webDefaults = new File(Jetty6Service.JETTY_DEFAULT_WEB_XML_FILE);
                if (webDefaults.exists()) {
                    webAppContext.setDefaultsDescriptor(webDefaults.toURL().toExternalForm());
                } else {
                    Jetty6Service.getLogger().log(BasicLevel.WARN, (Object)("The file '" + Jetty6Service.JETTY_DEFAULT_WEB_XML_FILE + "' is not present. Check that your JONAS_BASE is up-to-date."));
                }
                webAppContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)this.getJOnASClassPath(webClassLoader));
                webAppContext.setParentLoaderPriority(java2DelegationModel);
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Webapp class loader java 2 delegation model set to " + java2DelegationModel));
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server starting web app " + fileName));
                }
                this.webAppContexts.addHandler((Handler)webAppContext);
                oldCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(webClassLoader);
                try {
                    webAppContext.start();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldCL);
                }
                if (!Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) ** GOTO lbl84
                Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server is running web app " + fileName));
            }
            catch (IOException ioeExc) {
                err = "Cannot install this web application " + ioeExc;
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new JWebContainerServiceException(err, (Throwable)ioeExc);
            }
            catch (Exception eExc) {
                err = "Cannot start this web application " + eExc;
                Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err);
                throw new JWebContainerServiceException(err, (Throwable)eExc);
            }
        } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("No Jetty server to install web app " + fileName));
        }
lbl84:
        // 5 sources

        try {
            ctx.rebind("WebModule", (Object)this.getDummyJSR77ObjectName(hostName, contextRoot, earAppName));
        }
        catch (Exception e) {
            err = "Cannot rebind WebModule ObjectName in Context";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)err, (Throwable)e);
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
    }

    private ObjectName getDummyJSR77ObjectName(String hostName, String contextRoot, String earAppName) throws MalformedObjectNameException {
        return ObjectName.getInstance(this.getDomainName() + ":j2eeType=WebModule,name=" + "/" + contextRoot + ",J2EEApplication=" + earAppName + ",J2EEServer=" + this.getJonasServerName());
    }

    public String getJOnASClassPath(ClassLoader webClassLoader) {
        StringBuffer classpath = new StringBuffer();
        int n = 0;
        for (ClassLoader tmpLoader = webClassLoader; tmpLoader != null && tmpLoader instanceof URLClassLoader; tmpLoader = tmpLoader.getParent()) {
            URL[] repositories = ((URLClassLoader)tmpLoader).getURLs();
            for (int i = 0; i < repositories.length; ++i) {
                String repository = repositories[i].toString();
                if (repository.startsWith("file://")) {
                    repository = repository.substring("file://".length());
                } else {
                    if (!repository.startsWith("file:")) continue;
                    repository = repository.substring("file:".length());
                }
                if (repository == null) continue;
                if (n > 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(repository);
                ++n;
            }
        }
        return classpath.toString();
    }

    protected void doUnRegisterWar(Context ctx) throws JWebContainerServiceException {
        String contextRoot = null;
        try {
            contextRoot = (String)ctx.lookup("contextRoot");
        }
        catch (NamingException e) {
            String err = "Error while getting parameter from context param ";
            Jetty6Service.getLogger().log(BasicLevel.ERROR, (Object)(err + e.getMessage()));
            throw new JWebContainerServiceException(err, (Throwable)e);
        }
        if (contextRoot.equals("/")) {
            contextRoot = "";
        } else if (contextRoot.equalsIgnoreCase("ROOT")) {
            contextRoot = "";
        }
        if (this.server != null) {
            Handler[] handlers;
            WebAppContext webAppContext = null;
            for (Handler handler : handlers = this.webAppContexts.getHandlers()) {
                WebAppContext tmpContext;
                String contextPath;
                if (!(handler instanceof WebAppContext) || !contextRoot.equals(contextPath = (tmpContext = (WebAppContext)handler).getContextPath())) continue;
                webAppContext = tmpContext;
                break;
            }
            if (webAppContext != null) {
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server found and is stopping web app at context " + contextRoot));
                }
                try {
                    webAppContext.stop();
                }
                catch (Exception e) {
                    Jetty6Service.getLogger().log(BasicLevel.LEVEL_DEBUG, (Object)"Jetty server encoutered exception while stopping web application ", (Throwable)e);
                }
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server stopped and is removing web app at context " + contextRoot));
                }
                this.webAppContexts.removeHandler(webAppContext);
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server removed and is destroying web app at context " + contextRoot));
                }
                webAppContext.destroy();
                if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                    Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server unloaded web app at context " + contextRoot));
                }
            } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
                Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("Jetty server didn't find web app at context " + contextRoot));
            }
        } else if (Jetty6Service.getLogger().isLoggable(BasicLevel.DEBUG)) {
            Jetty6Service.getLogger().log(BasicLevel.DEBUG, (Object)("No Jetty server to install web app at context " + contextRoot));
        }
    }

    protected void updateServerInfos() {
        this.setServerName("Jetty");
        this.setServerVersion(Server.getVersion());
    }

    public String getDefaultHost() throws JWebContainerServiceException {
        Connector[] connectors = this.server.getConnectors();
        if (connectors.length == 0) {
            String err = "Cannot determine default host : Jetty server has no host!";
            throw new JWebContainerServiceException(err);
        }
        return connectors[0].getHost();
    }

    public String getDefaultHttpPort() throws JWebContainerServiceException {
        return String.valueOf(this.getFirstListenerFromScheme("http").getPort());
    }

    public String getDefaultHttpsPort() throws JWebContainerServiceException {
        return String.valueOf(this.getFirstListenerFromScheme("https").getPort());
    }

    private Connector getFirstListenerFromScheme(String myScheme) {
        Connector[] connectors = this.server.getConnectors();
        ArrayList<Connector> matchingConnectors = new ArrayList<Connector>();
        for (int i = 0; i < connectors.length; ++i) {
            Connector connector = connectors[i];
            String scheme = connector.getIntegralScheme();
            if (!scheme.equalsIgnoreCase(myScheme)) continue;
            matchingConnectors.add(connector);
        }
        if (matchingConnectors.isEmpty()) {
            String err = "Cannot determine default '" + myScheme + "' port :" + " Jetty server has 0 '" + myScheme + "' Listener";
            throw new JWebContainerServiceException(err);
        }
        Connector firstConnector = (Connector)matchingConnectors.get(0);
        if (matchingConnectors.size() > 1 && Jetty6Service.getLogger().isLoggable(BasicLevel.WARN)) {
            Jetty6Service.getLogger().log(BasicLevel.WARN, (Object)("Found multiple Listener for scheme '" + myScheme + "'" + ", using first by default! (port:" + firstConnector.getPort() + ")"));
        }
        return firstConnector;
    }
}

