/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Session;
import org.apache.catalina.ha.CatalinaCluster;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.ClusterManagerBase;
import org.apache.catalina.ha.session.DeltaSession;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.tribes.io.ReplicationStream;
import org.apache.catalina.tribes.tipis.AbstractReplicatedMap;
import org.apache.catalina.tribes.tipis.LazyReplicatedMap;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class BackupManager
extends StandardManager
implements ClusterManager,
AbstractReplicatedMap.MapOwner {
    public static Log log = LogFactory.getLog(BackupManager.class);
    protected static long DEFAULT_REPL_TIMEOUT = 15000L;
    protected boolean mExpireSessionsOnShutdown = true;
    protected String name;
    protected CatalinaCluster cluster;
    private boolean notifyListenersOnReplication;
    private int mapSendOptions = 6;

    public void messageDataReceived(ClusterMessage msg) {
    }

    public boolean doDomainReplication() {
        return false;
    }

    public void setDomainReplication(boolean sendClusterDomainOnly) {
    }

    public boolean isDefaultMode() {
        return false;
    }

    public void setDefaultMode(boolean defaultMode) {
    }

    public void setExpireSessionsOnShutdown(boolean expireSessionsOnShutdown) {
        this.mExpireSessionsOnShutdown = expireSessionsOnShutdown;
    }

    public void setCluster(CatalinaCluster cluster) {
        if (log.isDebugEnabled()) {
            log.debug("Cluster associated with SimpleTcpReplicationManager");
        }
        this.cluster = cluster;
    }

    public boolean getExpireSessionsOnShutdown() {
        return this.mExpireSessionsOnShutdown;
    }

    public void unload() throws IOException {
    }

    public ClusterMessage requestCompleted(String sessionId) {
        if (!this.started) {
            return null;
        }
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        map.replicate(sessionId, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectMadePrimay(Object key, Object value) {
        if (value != null && value instanceof DeltaSession) {
            DeltaSession session;
            DeltaSession deltaSession = session = (DeltaSession)value;
            synchronized (deltaSession) {
                session.access();
                session.endAccess();
            }
        }
    }

    public Session createEmptySession() {
        return new DeltaSession(this);
    }

    public ClassLoader[] getClassLoaders() {
        return ClusterManagerBase.getClassLoaders(this.container);
    }

    public ReplicationStream getReplicationStream(byte[] data) throws IOException {
        return this.getReplicationStream(data, 0, data.length);
    }

    public ReplicationStream getReplicationStream(byte[] data, int offset, int length) throws IOException {
        ByteArrayInputStream fis = new ByteArrayInputStream(data, offset, length);
        return new ReplicationStream(fis, this.getClassLoaders());
    }

    public String getName() {
        return this.name;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            return;
        }
        try {
            this.cluster.registerManager(this);
            CatalinaCluster catclust = this.cluster;
            LazyReplicatedMap map = new LazyReplicatedMap(this, catclust.getChannel(), DEFAULT_REPL_TIMEOUT, this.getMapName(), this.getClassLoaders());
            map.setChannelSendOptions(this.mapSendOptions);
            this.sessions = map;
            super.start();
            this.started = true;
        }
        catch (Exception x) {
            log.error("Unable to start BackupManager", x);
            throw new LifecycleException("Failed to start BackupManager", x);
        }
    }

    public String getMapName() {
        CatalinaCluster catclust = this.cluster;
        String name = catclust.getManagerName(this.getName(), this) + "-" + "map";
        if (log.isDebugEnabled()) {
            log.debug("Backup manager, Setting map name to:" + name);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws LifecycleException {
        if (this.sessions instanceof LazyReplicatedMap) {
            LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
            map.breakdown();
        }
        if (!this.started) {
            return;
        }
        super.stop();
        this.cluster.removeManager(this);
    }

    public void setDistributable(boolean dist) {
        this.distributable = dist;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNotifyListenersOnReplication() {
        return this.notifyListenersOnReplication;
    }

    public void setNotifyListenersOnReplication(boolean notifyListenersOnReplication) {
        this.notifyListenersOnReplication = notifyListenersOnReplication;
    }

    public void setMapSendOptions(int mapSendOptions) {
        this.mapSendOptions = mapSendOptions;
    }

    public CatalinaCluster getCluster() {
        return this.cluster;
    }

    public int getMapSendOptions() {
        return this.mapSendOptions;
    }

    public String[] getInvalidatedSessions() {
        return new String[0];
    }

    public ClusterManager cloneFromTemplate() {
        BackupManager result = new BackupManager();
        result.mExpireSessionsOnShutdown = this.mExpireSessionsOnShutdown;
        result.name = "Clone-from-" + this.name;
        result.cluster = this.cluster;
        result.notifyListenersOnReplication = this.notifyListenersOnReplication;
        result.mapSendOptions = this.mapSendOptions;
        return result;
    }

    public int getActiveSessionsFull() {
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        return map.sizeFull();
    }

    public String listSessionIdsFull() {
        StringBuffer sb = new StringBuffer();
        LazyReplicatedMap map = (LazyReplicatedMap)this.sessions;
        Iterator keys = map.keySetFull().iterator();
        while (keys.hasNext()) {
            sb.append(keys.next()).append(" ");
        }
        return sb.toString();
    }
}

