/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.CombinedRealm;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class LockOutRealm
extends CombinedRealm {
    private static Log log = LogFactory.getLog(LockOutRealm.class);
    protected int failureCount = 5;
    protected int lockOutTime = 300;
    protected int cacheSize = 1000;
    protected int cacheRemovalWarningTime = 3600;
    protected Map<String, LockRecord> failedUsers = null;

    public void start() throws LifecycleException {
        this.failedUsers = new LinkedHashMap<String, LockRecord>(this.cacheSize, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, LockRecord> eldest) {
                if (this.size() > LockOutRealm.this.cacheSize) {
                    long timeInCache = (System.currentTimeMillis() - eldest.getValue().getLastFailureTime()) / 1000L;
                    if (timeInCache < (long)LockOutRealm.this.cacheRemovalWarningTime) {
                        log.warn(CombinedRealm.sm.getString("lockOutRealm.removeWarning", eldest.getKey(), timeInCache));
                    }
                    return true;
                }
                return false;
            }
        };
        super.start();
    }

    public Principal authenticate(String username, byte[] credentials) {
        if (this.isLocked(username)) {
            this.registerAuthFailure(username);
            log.warn(sm.getString("lockOutRealm.authLockedUser", username));
            return null;
        }
        Principal authenticatedUser = super.authenticate(username, credentials);
        if (authenticatedUser == null) {
            this.registerAuthFailure(username);
        } else {
            this.registerAuthSuccess(username);
        }
        return authenticatedUser;
    }

    public Principal authenticate(String username, String clientDigest, String once, String nc, String cnonce, String qop, String realmName, String md5a2) {
        if (this.isLocked(username)) {
            this.registerAuthFailure(username);
            log.warn(sm.getString("lockOutRealm.authLockedUser", username));
            return null;
        }
        Principal authenticatedUser = super.authenticate(username, clientDigest, once, nc, cnonce, qop, realmName, md5a2);
        if (authenticatedUser == null) {
            this.registerAuthFailure(username);
        } else {
            this.registerAuthSuccess(username);
        }
        return authenticatedUser;
    }

    public Principal authenticate(String username, String credentials) {
        if (this.isLocked(username)) {
            this.registerAuthFailure(username);
            log.warn(sm.getString("lockOutRealm.authLockedUser", username));
            return null;
        }
        Principal authenticatedUser = super.authenticate(username, credentials);
        if (authenticatedUser == null) {
            this.registerAuthFailure(username);
        } else {
            this.registerAuthSuccess(username);
        }
        return authenticatedUser;
    }

    public Principal authenticate(X509Certificate[] certs) {
        String username = null;
        if (certs != null && certs.length > 0) {
            username = certs[0].getSubjectDN().getName();
        }
        if (this.isLocked(username)) {
            this.registerAuthFailure(username);
            log.warn(sm.getString("lockOutRealm.authLockedUser", username));
            return null;
        }
        Principal authenticatedUser = super.authenticate(certs);
        if (authenticatedUser == null) {
            this.registerAuthFailure(username);
        } else {
            this.registerAuthSuccess(username);
        }
        return authenticatedUser;
    }

    public void unlock(String username) {
        this.registerAuthSuccess(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLocked(String username) {
        LockRecord lockRecord = null;
        LockOutRealm lockOutRealm = this;
        synchronized (lockOutRealm) {
            lockRecord = this.failedUsers.get(username);
        }
        if (lockRecord == null) {
            return false;
        }
        return lockRecord.getFailures() >= this.failureCount && (System.currentTimeMillis() - lockRecord.getLastFailureTime()) / 1000L < (long)this.lockOutTime;
    }

    private synchronized void registerAuthSuccess(String username) {
        this.failedUsers.remove(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAuthFailure(String username) {
        LockRecord lockRecord = null;
        LockOutRealm lockOutRealm = this;
        synchronized (lockOutRealm) {
            if (!this.failedUsers.containsKey(username)) {
                lockRecord = new LockRecord();
                this.failedUsers.put(username, lockRecord);
            } else {
                lockRecord = this.failedUsers.get(username);
                if (lockRecord.getFailures() >= this.failureCount && (System.currentTimeMillis() - lockRecord.getLastFailureTime()) / 1000L > (long)this.lockOutTime) {
                    lockRecord.setFailures(0);
                }
            }
        }
        lockRecord.registerFailure();
    }

    public int getFailureCount() {
        return this.failureCount;
    }

    public void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public int getLockOutTime() {
        return this.lockOutTime;
    }

    public void setLockOutTime(int lockOutTime) {
        this.lockOutTime = lockOutTime;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public int getCacheRemovalWarningTime() {
        return this.cacheRemovalWarningTime;
    }

    public void setCacheRemovalWarningTime(int cacheRemovalWarningTime) {
        this.cacheRemovalWarningTime = cacheRemovalWarningTime;
    }

    protected class LockRecord {
        private AtomicInteger failures = new AtomicInteger(0);
        private long lastFailureTime = 0L;

        protected LockRecord() {
        }

        public int getFailures() {
            return this.failures.get();
        }

        public void setFailures(int theFailures) {
            this.failures.set(theFailures);
        }

        public long getLastFailureTime() {
            return this.lastFailureTime;
        }

        public void registerFailure() {
            this.failures.incrementAndGet();
            this.lastFailureTime = System.currentTimeMillis();
        }
    }
}

