/**
 * JOnAS: Java(TM) Open Application Server
 * Copyright (C) 1999 Bull S.A.
 * Contact: jonas-team@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * Initial Developer : Delplanque Xavier & Sauthier Guillaume
 * --------------------------------------------------------------------------
 * $Id: WSDLManager.java 12246 2007-12-09 21:42:38Z benoitf $
 * --------------------------------------------------------------------------
*/

package org.ow2.jonas.ws.base;

import java.util.Iterator;
import java.util.Vector;

import org.ow2.jonas.deployment.ws.ServiceDesc;
import org.ow2.jonas.ws.WSServiceException;
import org.ow2.jonas.ws.base.handler.WSDLHandler;



/**
 * Delegate publishing to all added WSDL Handlers.
 */
public class WSDLManager {
    /**
     * List of WSDL Handlers in charge of WSDL Publication
     */
    private Vector handlers;

    /**
     * Get a new instance of WSDLManager.
     */
    public WSDLManager() {
        handlers = new Vector();
    }

    /**
     * Add a WSDL Handler in charge of publish a wsdl file at a location.
     *
     * @param handler the new WSDL handler.
     */
    public void addHandler(WSDLHandler handler) {
        handlers.add(handler);
    }

    /**
     * Delegate publishing to all added WSDL Handlers.
     *
     * @param sd the ServiceDesc containing the wsdl file to publish.
     *
     * @throws WSServiceException When publication fails.
     */
    public void publish(ServiceDesc sd) throws WSServiceException {
        for (Iterator i = handlers.iterator(); i.hasNext();) {
            WSDLHandler wsdlh = (WSDLHandler) i.next();
            wsdlh.publish(sd);
        }
    }
}
