/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.base.audit;

import java.util.concurrent.atomic.AtomicLong;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.ow2.jonas.ws.jaxws.base.audit.AbstractJaxwsAuditHandler;
import org.ow2.util.auditreport.api.IAuditID;
import org.ow2.util.auditreport.api.ICurrentInvocationID;
import org.ow2.util.auditreport.impl.GenericAuditReport;
import org.ow2.util.auditreport.impl.JaxwsAuditReport;
import org.ow2.util.auditreport.impl.event.Event;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventDispatcher;
import org.ow2.util.event.api.IEventService;
import org.ow2.util.event.impl.EventDispatcher;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class JaxwsEndpointAuditHandler
extends AbstractJaxwsAuditHandler {
    public static final String REPORT_KEY = JaxwsEndpointAuditHandler.class.getName() + ".REPORT";
    public static final String AUDIT_ID_KEY = JaxwsEndpointAuditHandler.class.getName() + ".AUDIT_ID";
    public static final Log logger = LogFactory.getLog(JaxwsEndpointAuditHandler.class);
    private AtomicLong sequence = new AtomicLong();
    private boolean detailed = false;
    private ICurrentInvocationID current;
    private IEventService eventService = null;

    public JaxwsEndpointAuditHandler(ICurrentInvocationID current) {
        this(current, null);
    }

    public JaxwsEndpointAuditHandler(ICurrentInvocationID current, IEventService eventService) {
        this.current = current;
        this.eventService = eventService;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (this.isOutbound((MessageContext)context)) {
            JaxwsAuditReport report = (JaxwsAuditReport)context.get((Object)REPORT_KEY);
            if (report != null) {
                IAuditID old;
                report.setEndProcessingTimestamp(System.nanoTime());
                Event event = new Event((GenericAuditReport)report);
                if (this.eventService != null) {
                    EventDispatcher d = (EventDispatcher)this.eventService.getDispatcher("JAXWS");
                    if (d == null) {
                        d = new EventDispatcher();
                        d.setNbWorkers(2);
                        d.start();
                        this.eventService.registerDispatcher("JAXWS", (IEventDispatcher)d);
                    }
                    this.eventService.getDispatcher("JAXWS").dispatch((IEvent)event);
                }
                if ((old = (IAuditID)context.get((Object)AUDIT_ID_KEY)) != null) {
                    this.current.setAuditID(old);
                }
            }
        } else {
            IAuditID oldId = this.current.getAuditID();
            if (oldId != null) {
                this.current.newInvocation();
                IAuditID id = this.current.getAuditID();
                JaxwsAuditReport report = new JaxwsAuditReport();
                report.setKeyID(id.getID());
                report.setRequestTimeStamp(System.currentTimeMillis());
                report.setStartProcessingTimestamp(System.nanoTime());
                report.setServiceQName(context.get((Object)"javax.xml.ws.wsdl.service").toString());
                report.setPortQName(context.get((Object)"javax.xml.ws.wsdl.port").toString());
                report.setOperationQName(context.get((Object)"javax.xml.ws.wsdl.operation").toString());
                report.setSoapRoles(context.getRoles());
                context.put((Object)REPORT_KEY, (Object)report);
                context.put((Object)AUDIT_ID_KEY, (Object)oldId);
            }
        }
        return true;
    }

    public boolean isDetailed() {
        return this.detailed;
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
    }
}

