/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.easybeans.naming;

import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.ow2.easybeans.api.Factory;
import org.ow2.easybeans.deployment.helper.JavaContextHelper;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarClassMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarFieldMetadata;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.easybeans.deployment.util.BytecodeDescriptorHelper;
import org.ow2.easybeans.event.naming.JavaContextNamingEvent;
import org.ow2.jonas.ws.jaxws.client.JAXWSWebServiceRefBuilder;
import org.ow2.util.ee.metadata.common.api.struct.IJaxwsWebServiceRef;
import org.ow2.util.event.api.EventPriority;
import org.ow2.util.event.api.IEvent;
import org.ow2.util.event.api.IEventListener;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebServiceRefExtensionListener
implements IEventListener {
    private static Log logger = LogFactory.getLog(WebServiceRefExtensionListener.class);

    public boolean accept(IEvent event) {
        JavaContextNamingEvent javaContextNamingEvent;
        return event instanceof JavaContextNamingEvent && "java:".equals((javaContextNamingEvent = (JavaContextNamingEvent)event).getEventProviderId());
    }

    public EventPriority getPriority() {
        return EventPriority.SYNC_NORM;
    }

    public void handle(IEvent event) {
        String type;
        String name;
        String refName;
        IJaxwsWebServiceRef webServiceRef;
        List refs;
        JavaContextNamingEvent ene = (JavaContextNamingEvent)event;
        EasyBeansEjbJarClassMetadata bean = ene.getBeanMetadata();
        Factory easyBeansFactory = ene.getFactory();
        Context javaContext = ene.getJavaContext();
        Context envCtx = null;
        try {
            envCtx = (Context)javaContext.lookup("comp/env");
        }
        catch (NamingException e) {
            WebServiceRefExtensionListener.throwException(ene, new IllegalStateException("Cannot lookup java:comp/env element.", e));
        }
        logger.debug((Object)"Handling 'java:comp/env' building for EJB {0}", new Object[]{easyBeansFactory.getBeanInfo().getName()});
        IJaxwsWebServiceRef webServiceRefOnClass = bean.getJaxwsWebServiceRef();
        if (webServiceRefOnClass != null) {
            String name2 = webServiceRefOnClass.getName();
            this.createAndBindWebServiceReference(easyBeansFactory, envCtx, webServiceRefOnClass, name2, ene);
        }
        if ((refs = bean.getJaxwsWebServiceRefs()) != null && refs.size() > 0) {
            for (IJaxwsWebServiceRef webServiceRef2 : refs) {
                String name3 = webServiceRef2.getName();
                this.createAndBindWebServiceReference(easyBeansFactory, envCtx, webServiceRef2, name3, ene);
            }
        }
        for (EasyBeansEjbJarFieldMetadata fieldMetadata : bean.getStandardFieldMetadataCollection()) {
            webServiceRef = fieldMetadata.getJaxwsWebServiceRef();
            if (webServiceRef == null) continue;
            refName = webServiceRef.getName();
            name = JavaContextHelper.getJndiName((String)refName, (EasyBeansEjbJarFieldMetadata)fieldMetadata);
            type = BytecodeDescriptorHelper.getClassname((String)fieldMetadata.getJField().getDescriptor());
            webServiceRef.setType(type);
            this.createAndBindWebServiceReference(easyBeansFactory, envCtx, webServiceRef, name, ene);
        }
        for (EasyBeansEjbJarMethodMetadata methodMetadata : bean.getMethodMetadataCollection()) {
            webServiceRef = methodMetadata.getJaxwsWebServiceRef();
            if (webServiceRef == null) continue;
            refName = webServiceRef.getName();
            name = JavaContextHelper.getJndiName((String)refName, (EasyBeansEjbJarMethodMetadata)methodMetadata);
            type = BytecodeDescriptorHelper.getMethodParamClassname((String)methodMetadata.getJMethod().getDescriptor(), (int)0);
            webServiceRef.setType(type);
            this.createAndBindWebServiceReference(easyBeansFactory, envCtx, webServiceRef, name, ene);
        }
    }

    private void createAndBindWebServiceReference(Factory<?, ?> easyBeansFactory, Context envCtx, IJaxwsWebServiceRef ref, String name, JavaContextNamingEvent event) {
        try {
            Reference wsRef = this.getWebServiceReference(easyBeansFactory, ref);
            if (wsRef != null) {
                logger.debug((Object)"Rebind ''java:comp/env/{0}''", new Object[]{name});
                envCtx.rebind(name, (Object)wsRef);
            }
        }
        catch (NamingException e) {
            WebServiceRefExtensionListener.throwException(event, new IllegalStateException("Cannot bind element '" + name + "'.", e));
        }
    }

    private Reference getWebServiceReference(Factory<?, ?> easyBeansFactory, IJaxwsWebServiceRef webServiceRef) throws NamingException {
        JAXWSWebServiceRefBuilder builder = new JAXWSWebServiceRefBuilder();
        Reference ref = null;
        if (builder != null) {
            ref = builder.build(webServiceRef);
        }
        return ref;
    }

    private static void throwException(JavaContextNamingEvent event, Throwable throwable) {
        logger.error((Object)"Errors during Listeners processing.", new Object[]{throwable});
        event.addThrowable(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException("Wrapping cause", throwable);
    }
}

