/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap;

import java.lang.reflect.Field;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.ow2.opensuit.xmlmap.interfaces.IEnumeration;
import org.ow2.opensuit.xmlmap.interfaces.ISimpleType;
import org.ow2.opensuit.xmlmap.interfaces.IXmlImportable;
import org.ow2.opensuit.xmlmap.interfaces.IXmlObject;
import org.ow2.opensuit.xmlmap.interfaces.IXmlSubstitutionGroup;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.mapping.IMappingMethod;
import org.ow2.opensuit.xmlmap.mapping.MappingError;

public class BindWithNamingRules
extends IMappingMethod {
    private static final String CONTENT_FIELD = "_xmlcontent";
    private static final String PARENT_FIELD = "_xmlparent";
    private static final String ANCESTOR_FIELD = "_xmlancestor";
    private static final String ROOT_FIELD = "_xmlroot";
    private static final String ATTR_PREFIX = "_xmlattr_";
    private static final String NODE_PREFIX = "_xmlnode_";
    private static final String COLLECT_PREFIX = "_xmlcollect_";
    private static int JVM_FIELD_ENUM_DIRECTION = 0;
    private Hashtable _class2Fields = new Hashtable();
    static /* synthetic */ Class class$java$lang$Object;

    private static boolean fieldEnumFollowsDeclaration() {
        if (JVM_FIELD_ENUM_DIRECTION == 0) {
            Field[] fields = TestClass.class.getDeclaredFields();
            JVM_FIELD_ENUM_DIRECTION = fields[0].getName().equals("field1") ? 1 : -1;
        }
        return JVM_FIELD_ENUM_DIRECTION == 1;
    }

    public boolean isSimpleType(Class c) {
        return ISimpleType.class.isAssignableFrom(c);
    }

    public boolean isEnumeration(Class c) {
        return IEnumeration.class.isAssignableFrom(c);
    }

    public boolean isImportable(Class c) {
        return IXmlImportable.class.isAssignableFrom(c);
    }

    public boolean isSubstitutionGroup(Class c) {
        return IXmlSubstitutionGroup.class.isAssignableFrom(c);
    }

    public boolean isXmlElement(Class c) {
        return IXmlObject.class.isAssignableFrom(c);
    }

    public Class getBaseSimpleType(Class c) {
        return String.class;
    }

    protected void populateMappings(List mappedFields, List mappingErrors, Class iClass, Class iExcludeFrom) {
        if (iClass.getSuperclass() != null && iClass.getSuperclass() != iExcludeFrom) {
            this.populateMappings(mappedFields, mappingErrors, iClass.getSuperclass(), iExcludeFrom);
        }
        Field[] fields = iClass.getDeclaredFields();
        boolean fieldsInDeclOrder = BindWithNamingRules.fieldEnumFollowsDeclaration();
        for (int i = 0; i < fields.length; ++i) {
            try {
                int idx = fieldsInDeclOrder ? i : fields.length - i - 1;
                FieldMapping mapping = BindWithNamingRules.getXmlMapping(fields[idx]);
                if (mapping == null) continue;
                mappedFields.add(mapping);
                continue;
            }
            catch (MappingError e) {
                mappingErrors.add(e);
            }
        }
    }

    private static void extractMinMaxInfo(Field field, String iPrefix, FieldMapping ret) throws MappingError {
        if (field.getType().isArray() && field.getType() != [B.class) {
            int idx1 = field.getName().indexOf(95, iPrefix.length());
            if (idx1 < 0) {
                throw new MappingError("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': missing 'minOccurs' part.");
            }
            int idx2 = field.getName().indexOf(95, idx1 + 1);
            if (idx2 < 0) {
                throw new MappingError("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': missing 'maxOccurs' part.");
            }
            ret.setName(field.getName().substring(idx2 + 1));
            try {
                ret.setMinOccurs(Integer.parseInt(field.getName().substring(iPrefix.length(), idx1)));
            }
            catch (Exception e) {
                throw new MappingError("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': the 'minOccurs' part is not a number.");
            }
            String max = field.getName().substring(idx1 + 1, idx2);
            if ("unbounded".startsWith(max)) {
                ret.setMaxOccurs(Integer.MAX_VALUE);
            } else {
                try {
                    ret.setMaxOccurs(Integer.parseInt(max));
                }
                catch (Exception e) {
                    throw new MappingError("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': the 'maxOccurs' part is not a number, nor 'unbounded'.");
                }
            }
        } else {
            int idx = field.getName().indexOf(95, iPrefix.length());
            if (idx < 0) {
                throw new MappingError("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': no 'use' part (required|optional).");
            }
            ret.setName(field.getName().substring(idx + 1));
            ret.setMaxOccurs(1);
            String use = field.getName().substring(iPrefix.length(), idx);
            if ("required".startsWith(use)) {
                ret.setMinOccurs(1);
            } else if ("optional".startsWith(use)) {
                ret.setMinOccurs(0);
            } else {
                throw new MappingError("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': 'use' part not in (required|optional).");
            }
        }
    }

    protected static FieldMapping getXmlMapping(Field field) throws MappingError {
        if (field.getName().startsWith(ATTR_PREFIX)) {
            if (field.getType().isArray() && field.getType() != [B.class) {
                throw new MappingError("XmlMapping error in field '" + field.getDeclaringClass().getName() + "/" + field.getName() + "': mapping to an xmlattr involves the field type is not an array.");
            }
            FieldMapping ret = new FieldMapping(field);
            ret.setType(1);
            BindWithNamingRules.extractMinMaxInfo(field, ATTR_PREFIX, ret);
            return ret;
        }
        if (field.getName().startsWith(NODE_PREFIX)) {
            FieldMapping ret = new FieldMapping(field);
            ret.setType(2);
            BindWithNamingRules.extractMinMaxInfo(field, NODE_PREFIX, ret);
            return ret;
        }
        if (field.getName().startsWith(COLLECT_PREFIX)) {
            FieldMapping ret = new FieldMapping(field);
            ret.setType(4);
            BindWithNamingRules.extractMinMaxInfo(field, COLLECT_PREFIX, ret);
            return ret;
        }
        if (field.getName().equals(CONTENT_FIELD)) {
            FieldMapping ret = new FieldMapping(field);
            ret.setType(8);
            return ret;
        }
        if (field.getName().startsWith(ANCESTOR_FIELD)) {
            FieldMapping ret = new FieldMapping(field);
            ret.setType(64);
            return ret;
        }
        if (field.getName().equals(PARENT_FIELD)) {
            FieldMapping ret = new FieldMapping(field);
            ret.setType(16);
            return ret;
        }
        if (field.getName().equals(ROOT_FIELD)) {
            FieldMapping ret = new FieldMapping(field);
            ret.setType(32);
            return ret;
        }
        return null;
    }

    public int getNbOfEnumItems(Class iEnumClass) {
        return this.getEnumItems(iEnumClass).length;
    }

    public Object getEnumItem(Class iEnumClass, String iName) {
        Field[] elements = this.getEnumItems(iEnumClass);
        for (int i = 0; i < elements.length; ++i) {
            if (!elements[i].getName().equals(iName)) continue;
            try {
                return (IEnumeration)elements[i].get(null);
            }
            catch (Exception e) {
                System.out.println("Enum Error:");
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public Object getEnumItem(Class iEnumClass, int iIndex) {
        Field[] elements = this.getEnumItems(iEnumClass);
        if (iIndex >= elements.length) {
            return null;
        }
        try {
            return (IEnumeration)elements[iIndex].get(null);
        }
        catch (Exception e) {
            System.out.println("Enum Error:");
            e.printStackTrace();
            return null;
        }
    }

    public String getEnumItemName(Class iEnumClass, int iIndex) {
        Field[] elements = this.getEnumItems(iEnumClass);
        if (iIndex >= elements.length) {
            return null;
        }
        return elements[iIndex].getName();
    }

    public String getEnumItemName(Object iEnumValue) {
        Field[] elements = this.getEnumItems(iEnumValue.getClass());
        for (int i = 0; i < elements.length; ++i) {
            try {
                if (iEnumValue != elements[i].get(null)) continue;
                return elements[i].getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private Field[] getEnumItems(Class iEnumClass) {
        Object[] elements = (Field[])this._class2Fields.get(iEnumClass);
        if (elements == null) {
            Vector<Field> elementFields = new Vector<Field>();
            Field[] fields = iEnumClass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if ((fields[i].getModifiers() & 8) == 0 || !fields[i].getType().equals(iEnumClass)) continue;
                elementFields.addElement(fields[i]);
            }
            elements = new Field[elementFields.size()];
            elementFields.copyInto(elements);
            this._class2Fields.put(iEnumClass, elements);
        }
        return elements;
    }

    private static String getMessage(Locale iLocale, Class iComponentClass, String iKey, String iDefault) {
        for (Class c = iComponentClass; c != null && c != (class$java$lang$Object == null ? BindWithNamingRules.class$("java.lang.Object") : class$java$lang$Object); c = c.getSuperclass()) {
            try {
                ResourceBundle rb = ResourceBundle.getBundle(c.getName(), iLocale);
                String msg = rb.getString(iKey);
                if (msg == null) continue;
                return msg;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return iDefault;
    }

    public String getInstanceName(Locale iLocale, Object iObj) {
        String instName = BindWithNamingRules.getMessage(iLocale, iObj.getClass(), "InstName", null);
        if (instName != null) {
            ElementMapping mappings = this.getElementMappings(iObj.getClass(), true);
            StringBuffer sb = new StringBuffer();
            int curIdx = 0;
            while (true) {
                int idx1;
                int idx2;
                int n = idx2 = (idx1 = instName.indexOf(37, curIdx)) < 0 ? -1 : instName.indexOf(37, idx1 + 1);
                if (idx2 < 0) {
                    sb.append(instName.substring(curIdx));
                    return sb.toString();
                }
                String mappingName = instName.substring(idx1 + 1, idx2);
                FieldMapping mapping = mappings.getMappingByNameAndType(mappingName, 1);
                if (mapping == null) break;
                Object val = null;
                try {
                    val = mapping.getField().get(iObj);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (val == null) break;
                sb.append(instName.substring(curIdx, idx1));
                sb.append(String.valueOf(val));
                curIdx = idx2 + 1;
            }
        }
        return this.getElementTitle(iLocale, iObj.getClass());
    }

    public String getElementTitle(Locale iLocale, Class iComponentClass) {
        String name = BindWithNamingRules.getMessage(iLocale, iComponentClass, "Name", null);
        if (name != null) {
            return name;
        }
        int idx = iComponentClass.getName().lastIndexOf(46);
        if (idx >= 0) {
            return iComponentClass.getName().substring(idx + 1);
        }
        return iComponentClass.getName();
    }

    public String getElementDetails(Locale iLocale, Class iComponentClass) {
        return BindWithNamingRules.getMessage(iLocale, iComponentClass, "Details", null);
    }

    public String getMappingTitle(Locale iLocale, FieldMapping mapping) {
        return BindWithNamingRules.getMessage(iLocale, mapping.getField().getDeclaringClass(), mapping.getName() + ".Name", mapping.getName());
    }

    public String getMappingDetails(Locale iLocale, FieldMapping mapping) {
        return BindWithNamingRules.getMessage(iLocale, mapping.getField().getDeclaringClass(), mapping.getName() + ".Details", null);
    }

    public String getEnumItemDetails(Locale locale, Class enumClass, String name) {
        return BindWithNamingRules.getMessage(locale, enumClass, name + ".Details", null);
    }

    private static class TestClass {
        private Object field1;
        private Object field2;

        private TestClass() {
        }
    }
}

