/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.schema.ISchema;
import org.ow2.opensuit.xmlmap.schema.ISchemaElement;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.opensuit.xmlmap.utils.ClassHelper;

public class DocletsGenerator {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("usage: DocletsGenerator [src_dir] [java_package]");
            return;
        }
        String srcDir = args[0];
        String javaPackage = args[1];
        try {
            System.out.println("Generate Documentation from code");
            System.out.println("--------------------------------");
            System.out.println("  - source directory           : " + srcDir);
            System.out.println("  - root code package     : " + javaPackage);
            SchemasManager schemas = new SchemasManager();
            ISchema mainSchema = schemas.declareSchema(javaPackage, javaPackage, javaPackage);
            mainSchema.buildFromClassPath();
            ISchemaElement[] elements = mainSchema.getAllElements();
            for (int i = 0; i < elements.length; ++i) {
                File pptiesFile = new File(srcDir + "/" + elements[i].getMappedClass().getName().replace('.', '/') + ".properties");
                if (!pptiesFile.exists()) {
                    System.out.println("Need to create " + pptiesFile);
                    PrintWriter writer = new PrintWriter(new FileOutputStream(pptiesFile));
                    if (mainSchema.getMethod().isEnumeration(elements[i].getMappedClass())) {
                        int nbItems = mainSchema.getMethod().getNbOfEnumItems(elements[i].getMappedClass());
                        writer.println("# ================================================");
                        writer.println("# XMLMap doclet for enumeration " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()));
                        writer.println("# ================================================");
                        writer.println("Name = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()));
                        writer.println("Details = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()) + " details (TODO).");
                        writer.println();
                        for (int j = 0; j < nbItems; ++j) {
                            String itemName = mainSchema.getMethod().getEnumItemName(elements[i].getMappedClass(), j);
                            writer.println(itemName + ".Name = " + itemName);
                            writer.println(itemName + ".Details = " + itemName + " details (TODO).");
                        }
                    } else {
                        FieldMapping[] fields;
                        ElementMapping mappings = mainSchema.getMethod().getElementMappings(elements[i].getMappedClass(), false);
                        writer.println("# ================================================");
                        writer.println("# XMLMap doclet for component " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()));
                        writer.println("# ================================================");
                        writer.println("InstName = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()));
                        writer.println("Name = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()));
                        writer.println("Details = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()) + " details (TODO).");
                        writer.println();
                        if (mappings instanceof ElementMapping && (fields = mappings.getMappings(15)) != null && fields.length > 0) {
                            for (int j = 0; j < fields.length; ++j) {
                                writer.println("" + fields[j].getName() + ".Name = " + fields[j].getName());
                                writer.println("" + fields[j].getName() + ".Details = " + fields[j].getName() + " details (TODO).");
                                writer.println();
                            }
                        }
                    }
                    writer.flush();
                    writer.close();
                    continue;
                }
                Properties doclet = new Properties();
                FileInputStream in = new FileInputStream(pptiesFile);
                doclet.load(in);
                ((InputStream)in).close();
                ArrayList<String> toAdd = new ArrayList<String>();
                if (mainSchema.getMethod().isEnumeration(elements[i].getMappedClass())) {
                    int nbItems = mainSchema.getMethod().getNbOfEnumItems(elements[i].getMappedClass());
                    if (doclet.getProperty("Name") == null) {
                        toAdd.add("Name = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()));
                    }
                    if (doclet.getProperty("Details") == null) {
                        toAdd.add("Details = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()) + " details (TODO).");
                    }
                    for (int j = 0; j < nbItems; ++j) {
                        String itemName = mainSchema.getMethod().getEnumItemName(elements[i].getMappedClass(), j);
                        if (doclet.getProperty(itemName + ".Name") == null) {
                            toAdd.add(itemName + ".Name = " + itemName);
                        }
                        if (doclet.getProperty(itemName + ".Details") != null) continue;
                        toAdd.add(itemName + ".Details = " + itemName + " details (TODO).");
                    }
                } else {
                    FieldMapping[] fields;
                    ElementMapping mappings = mainSchema.getMethod().getElementMappings(elements[i].getMappedClass(), false);
                    if (doclet.getProperty("InstName") == null) {
                        toAdd.add("InstName = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()));
                    }
                    if (doclet.getProperty("Name") == null) {
                        toAdd.add("Name = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()));
                    }
                    if (doclet.getProperty("Details") == null) {
                        toAdd.add("Details = " + ClassHelper.getSimpleName((Class)elements[i].getMappedClass()) + " details (TODO).");
                    }
                    if (mappings instanceof ElementMapping && (fields = mappings.getMappings(15)) != null && fields.length > 0) {
                        for (int j = 0; j < fields.length; ++j) {
                            if (doclet.getProperty("" + fields[j].getName() + ".Name") == null) {
                                toAdd.add("" + fields[j].getName() + ".Name = " + fields[j].getName());
                            }
                            if (doclet.getProperty("" + fields[j].getName() + ".Details") != null) continue;
                            toAdd.add("" + fields[j].getName() + ".Details = " + fields[j].getName() + " details (TODO).");
                        }
                    }
                }
                if (toAdd.size() <= 0) continue;
                System.out.println("Need to add some keys to " + pptiesFile);
                BufferedReader reader = new BufferedReader(new FileReader(pptiesFile));
                StringBuffer originalContent = new StringBuffer();
                String l = null;
                while ((l = reader.readLine()) != null) {
                    originalContent.append(l);
                    originalContent.append('\n');
                }
                reader.close();
                PrintWriter writer = new PrintWriter(new FileOutputStream(pptiesFile));
                writer.println(originalContent.toString());
                for (int j = 0; j < toAdd.size(); ++j) {
                    writer.println(toAdd.get(j));
                }
                writer.close();
            }
            System.out.println("... Done.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

