/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.opensuit.xmlmap;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ow2.opensuit.xmlmap.mapping.ElementMapping;
import org.ow2.opensuit.xmlmap.mapping.FieldMapping;
import org.ow2.opensuit.xmlmap.mapping.IMappingMethod;
import org.ow2.opensuit.xmlmap.schema.ISchema;
import org.ow2.opensuit.xmlmap.schema.ISchemaElement;
import org.ow2.opensuit.xmlmap.schema.SchemasManager;
import org.ow2.opensuit.xmlmap.utils.ClassHelper;

public class Migrator {
    private static StringBuffer sourceBuffer = new StringBuffer();
    private static Pattern FIELD_DECLARATION_PATTERN = Pattern.compile("\\n(\\s*)(public|protected|private)(\\s+(static))?\\s+(\\w+(\\[\\])?)\\s+(\\w+)\\s*([\\=\\;])");
    private static Pattern TYPE_DECLARATION_PATTERN = Pattern.compile("\\b(public|protected|private)(\\s+(abstract))?\\s+(class|interface|enum)\\s+(\\w+)(\\s+extends\\s+\\w+(\\s*,\\s*\\w+)*)?(\\s+implements\\s+\\w+(\\s*,\\s*\\w+)*)?(\\s+throws\\s+\\w+(\\s*,\\s*\\w+)*)?");
    private static List javaKeyWords = new ArrayList();

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: Migrator [src_dir] [dest_dir] [java_package]");
            return;
        }
        String srcDir = args[0];
        String destDir = args[1];
        String javaPackage = args[2];
        System.out.println("Migrate XML Mappings from 'Naming Rules' to 'Java 5 Annotations'");
        System.out.println("----------------------------------------------------------------");
        System.out.println("  - source directory           : " + srcDir);
        System.out.println("  - destination directory      : " + destDir);
        System.out.println("  - root code package     : " + javaPackage);
        Migrator.migratePackage(javaPackage, srcDir, destDir);
    }

    public static void mainOFF(String[] args) throws IOException {
        StringBuffer code = Migrator.readFileContent(new File("E:/CRHX7117/Dev/Workspaces/TODO/root-builder/core/src/main/java/org/ow2/opensuit/xml/base/html/table/Table.java"));
        Matcher m = TYPE_DECLARATION_PATTERN.matcher(code);
        StringBuffer replacement = new StringBuffer();
        while (m.find()) {
            System.out.println("found: " + m.group());
            for (int i = 0; i < m.groupCount(); ++i) {
                System.out.println(" -" + i + ": " + m.group(i + 1));
            }
            m.appendReplacement(replacement, "replaced...");
        }
        m.appendTail(replacement);
        System.out.println(replacement.toString());
    }

    private static void migratePackage(String packageName, String srcDir, String destDir) {
        SchemasManager schemas = new SchemasManager();
        ISchema mainSchema = schemas.declareSchema(packageName, packageName, packageName);
        try {
            mainSchema.buildFromClassPath();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return;
        }
        File rootPackageDir = new File(srcDir + "/" + packageName.replace('.', '/'));
        Migrator.migrateDir(mainSchema, destDir, rootPackageDir, packageName);
    }

    private static int migrateDir(ISchema schema, String destDir, File packageDir, String iPackage) {
        if (!packageDir.exists()) {
            return 0;
        }
        String[] names = packageDir.list();
        int processed = 0;
        for (int i = 0; i < names.length; ++i) {
            File f = new File(packageDir, names[i]);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                processed += Migrator.migrateDir(schema, destDir, new File(packageDir, names[i]), iPackage + "." + names[i]);
                continue;
            }
            if (!names[i].endsWith(".java")) continue;
            String className = iPackage + "." + names[i].substring(0, names[i].length() - 5);
            try {
                Class<?> c = Class.forName(className);
                File javaDestSource = new File(destDir + "/" + c.getName().replace('.', '/') + ".java");
                ISchemaElement elt = schema.getElement(c);
                if (elt == null) {
                    StringBuffer source = Migrator.readFileContent(f);
                    Migrator.writeFileContent(javaDestSource, source);
                } else {
                    Migrator.migrateSource(elt, f, javaDestSource);
                }
                ++processed;
                continue;
            }
            catch (Throwable e) {
                Migrator.error(f, "Error while processing file.", e);
            }
        }
        return processed;
    }

    private static void info(File file, String message) {
    }

    private static void warning(File file, String message) {
        System.out.println("[WARN] [" + file.getPath() + "] " + message);
    }

    private static void error(File file, String message, Throwable t) {
        System.out.println("[ERROR] [" + file.getPath() + "] " + message);
        if (t != null) {
            t.printStackTrace(System.out);
        }
    }

    private static void writeFileContent(File file, StringBuffer content) throws IOException {
        file.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(file);
        writer.write(content.toString());
        writer.flush();
        writer.close();
    }

    private static StringBuffer readFileContent(File file) throws IOException {
        FileReader reader = new FileReader(file);
        sourceBuffer.setLength(0);
        char[] buffer = new char[512];
        int l = 0;
        while ((l = reader.read(buffer)) >= 0) {
            sourceBuffer.append(buffer, 0, l);
        }
        reader.close();
        return sourceBuffer;
    }

    private static StringBuffer replaceImports(File file, StringBuffer input, List importsToRemove, List importsToAdd) {
        StringBuffer newImports = new StringBuffer();
        for (int j = 0; j < importsToAdd.size(); ++j) {
            newImports.append("import ");
            newImports.append(importsToAdd.get(j));
            newImports.append(";\n");
        }
        boolean added = false;
        for (int i = 0; i < importsToRemove.size(); ++i) {
            String className = (String)importsToRemove.get(i);
            Pattern p = Pattern.compile("import\\s+" + className.replaceAll("\\.", "\\.") + "\\s*\\;");
            Matcher m = p.matcher(input);
            StringBuffer ret = new StringBuffer(input.length());
            if (m.find()) {
                String replacement = "";
                if (!added) {
                    replacement = newImports.toString();
                    added = true;
                }
                m.appendReplacement(ret, replacement);
            }
            m.appendTail(ret);
            input = ret;
        }
        if (!added) {
            Pattern p = Pattern.compile("package\\s+[\\w\\.]+\\s*\\;");
            Matcher m = p.matcher(input);
            StringBuffer ret = new StringBuffer(input.length());
            if (m.find()) {
                m.appendReplacement(ret, m.group() + "\n" + newImports.toString());
                m.appendTail(ret);
                input = ret;
            } else {
                Migrator.warning(file, "new imports not added: \n" + newImports.toString());
            }
        }
        return input;
    }

    private static void migrateSource(ISchemaElement element, File javaOldSource, File javaNewSource) throws IOException {
        Migrator.info(javaOldSource, "Migrating source: " + javaOldSource.getPath());
        StringBuffer sourceCode = Migrator.readFileContent(javaOldSource);
        IMappingMethod method = element.getSchema().getMethod();
        switch (element.getType()) {
            case 1: {
                ArrayList<String> importsToRemove = new ArrayList<String>();
                importsToRemove.add("org.ow2.opensuit.xmlmap.interfaces.IEnumeration");
                ArrayList<String> importsToAdd = new ArrayList<String>();
                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlDoc");
                Matcher typeDeclMatcher = TYPE_DECLARATION_PATTERN.matcher(sourceCode);
                if (typeDeclMatcher.find()) {
                    StringBuffer tempBuffer;
                    StringBuffer annotations = new StringBuffer();
                    String doc = method.getElementDetails(Locale.ENGLISH, element.getMappedClass());
                    if (doc != null) {
                        annotations.append(Migrator.buildDocAnnotation(doc));
                    }
                    TypeDeclaration declaration = new TypeDeclaration(typeDeclMatcher);
                    Migrator.info(javaOldSource, "type declaration: " + declaration.toCode());
                    if (declaration.implementsList.remove("IEnumeration")) {
                        importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlEnumeration");
                        annotations.append("@XmlEnumeration\n");
                        tempBuffer = new StringBuffer(sourceCode.length());
                        typeDeclMatcher.appendReplacement(tempBuffer, annotations.toString() + declaration.toCode());
                        typeDeclMatcher.appendTail(tempBuffer);
                        sourceCode = tempBuffer;
                    } else {
                        Migrator.warning(javaOldSource, "Doesn't implement IEnumeration");
                        if (annotations.length() > 0) {
                            tempBuffer = new StringBuffer(sourceCode.length());
                            typeDeclMatcher.appendReplacement(tempBuffer, Migrator.buildDocAnnotation(doc) + typeDeclMatcher.group());
                            typeDeclMatcher.appendTail(tempBuffer);
                            sourceCode = tempBuffer;
                        }
                    }
                } else {
                    Migrator.warning(javaOldSource, "Type declaration not found");
                }
                int nbEnumItems = method.getNbOfEnumItems(element.getMappedClass());
                ArrayList<String> itemNames = new ArrayList<String>(nbEnumItems);
                for (int i = 0; i < nbEnumItems; ++i) {
                    itemNames.add(method.getEnumItemName(element.getMappedClass(), i));
                }
                StringBuffer tempBuffer = new StringBuffer(sourceCode.length());
                Matcher fieldDeclMatcher = FIELD_DECLARATION_PATTERN.matcher(sourceCode);
                while (fieldDeclMatcher.find()) {
                    FieldDeclaration declaration = new FieldDeclaration(fieldDeclMatcher);
                    Migrator.info(javaOldSource, "field declaration: " + declaration.toCode());
                    if (!itemNames.contains(declaration.name)) continue;
                    StringBuffer annotations = new StringBuffer();
                    String doc = method.getEnumItemDetails(Locale.ENGLISH, element.getMappedClass(), declaration.name);
                    if (doc != null) {
                        annotations.append(declaration.indent);
                        annotations.append(Migrator.buildDocAnnotation(doc));
                    }
                    if (annotations.length() <= 0) continue;
                    fieldDeclMatcher.appendReplacement(tempBuffer, annotations.toString() + fieldDeclMatcher.group());
                }
                fieldDeclMatcher.appendTail(tempBuffer);
                sourceCode = tempBuffer;
                sourceCode = Migrator.replaceImports(javaOldSource, sourceCode, importsToRemove, importsToAdd);
                break;
            }
            case 2: {
                ArrayList<String> importsToRemove = new ArrayList<String>();
                importsToRemove.add("org.ow2.opensuit.xmlmap.interfaces.IXmlSubstitutionGroup");
                importsToRemove.add("org.ow2.opensuit.xmlmap.interfaces.IXmlImportable");
                ArrayList<String> importsToAdd = new ArrayList<String>();
                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlDoc");
                Matcher typeDeclMatcher = TYPE_DECLARATION_PATTERN.matcher(sourceCode);
                if (typeDeclMatcher.find()) {
                    TypeDeclaration declaration = new TypeDeclaration(typeDeclMatcher);
                    StringBuffer annotations = new StringBuffer();
                    String doc = method.getElementDetails(Locale.ENGLISH, element.getMappedClass());
                    if (doc != null) {
                        annotations.append(Migrator.buildDocAnnotation(doc));
                    }
                    Migrator.info(javaOldSource, "type declaration: " + declaration.toCode());
                    if (declaration.extendsList.remove("IXmlSubstitutionGroup")) {
                        if ("interface".equals(declaration.type) && declaration.extendsList.remove("IXmlObject")) {
                            importsToRemove.add("org.ow2.opensuit.xmlmap.interfaces.IXmlObject");
                        }
                        importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlSubstitutionGroup");
                        if (declaration.extendsList.remove("IXmlImportable")) {
                            annotations.append("@XmlSubstitutionGroup(importable=true)\n");
                        } else {
                            annotations.append("@XmlSubstitutionGroup\n");
                        }
                        StringBuffer tempBuffer = new StringBuffer(sourceCode.length());
                        typeDeclMatcher.appendReplacement(tempBuffer, annotations.toString() + declaration.toCode());
                        typeDeclMatcher.appendTail(tempBuffer);
                        sourceCode = tempBuffer;
                    } else {
                        Migrator.warning(javaOldSource, "Doesn't extend IXmlSubstitutionGroup");
                        if (annotations.length() > 0) {
                            StringBuffer tempBuffer = new StringBuffer(sourceCode.length());
                            typeDeclMatcher.appendReplacement(tempBuffer, annotations.toString() + typeDeclMatcher.group());
                            typeDeclMatcher.appendTail(tempBuffer);
                            sourceCode = tempBuffer;
                        }
                    }
                } else {
                    Migrator.warning(javaOldSource, "Type declaration not found");
                }
                sourceCode = Migrator.replaceImports(javaOldSource, sourceCode, importsToRemove, importsToAdd);
                break;
            }
            case 4: {
                ArrayList<String> importsToRemove = new ArrayList<String>();
                importsToRemove.add("org.ow2.opensuit.xmlmap.interfaces.IXmlObject");
                ArrayList<String> importsToAdd = new ArrayList<String>();
                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlDoc");
                Matcher typeDeclMatcher = TYPE_DECLARATION_PATTERN.matcher(sourceCode);
                if (typeDeclMatcher.find()) {
                    StringBuffer annotations = new StringBuffer();
                    String doc = method.getElementDetails(Locale.ENGLISH, element.getMappedClass());
                    if (doc != null) {
                        annotations.append(Migrator.buildDocAnnotation(doc));
                    }
                    TypeDeclaration declaration = new TypeDeclaration(typeDeclMatcher);
                    Migrator.info(javaOldSource, "type declaration: " + declaration.toCode());
                    if (!declaration.implementsList.remove("IXmlObject")) {
                        Migrator.warning(javaOldSource, "Doesn't implement IXmlObject");
                    }
                    importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlElement");
                    importsToAdd.add("org.ow2.opensuit.xmlmap.interfaces.IInitializable");
                    declaration.implementsList.add("IInitializable");
                    annotations.append("@XmlElement\n");
                    StringBuffer tempBuffer = new StringBuffer(sourceCode.length());
                    try {
                        typeDeclMatcher.appendReplacement(tempBuffer, annotations.toString() + declaration.toCode());
                    }
                    catch (IllegalArgumentException e) {
                        Migrator.error(javaOldSource, "Illegal argument with replacement: \n" + annotations.toString() + declaration.toCode(), null);
                        throw e;
                    }
                    typeDeclMatcher.appendTail(tempBuffer);
                    sourceCode = tempBuffer;
                } else {
                    Migrator.warning(javaOldSource, "Type declaration not found");
                }
                ElementMapping mapping = method.getElementMappings(element.getMappedClass(), false);
                FieldMapping[] allFieldMappings = mapping.getMappings(0);
                StringBuffer tempBuffer = new StringBuffer(sourceCode.length());
                Matcher fieldDeclMatcher = FIELD_DECLARATION_PATTERN.matcher(sourceCode);
                while (fieldDeclMatcher.find()) {
                    String newFieldName;
                    FieldDeclaration declaration = new FieldDeclaration(fieldDeclMatcher);
                    Migrator.info(javaOldSource, "field declaration: " + declaration.toCode());
                    FieldMapping fieldMapping = null;
                    for (int i = 0; i < allFieldMappings.length; ++i) {
                        if (!allFieldMappings[i].getField().getName().equals(declaration.name)) continue;
                        fieldMapping = allFieldMappings[i];
                        break;
                    }
                    if (fieldMapping == null) continue;
                    Migrator.info(javaOldSource, "--> mapped field");
                    StringBuffer annotations = new StringBuffer();
                    String doc = method.getMappingDetails(Locale.ENGLISH, fieldMapping);
                    if (doc != null) {
                        annotations.append(declaration.indent);
                        annotations.append(Migrator.buildDocAnnotation(doc));
                    }
                    declaration.name = newFieldName = Migrator.getMigratedFieldName(fieldMapping);
                    switch (fieldMapping.getType()) {
                        case 64: {
                            if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlAncestor")) {
                                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlAncestor");
                            }
                            annotations.append(declaration.indent);
                            annotations.append("@XmlAncestor\n");
                            break;
                        }
                        case 1: {
                            if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlAttribute")) {
                                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlAttribute");
                            }
                            annotations.append(declaration.indent);
                            annotations.append("@XmlAttribute");
                            boolean added = false;
                            if (newFieldName != fieldMapping.getName()) {
                                annotations.append(added ? ", " : "(");
                                added = true;
                                annotations.append("name=\"");
                                annotations.append(fieldMapping.getName());
                                annotations.append("\"");
                            }
                            if (fieldMapping.getMinOccurs() == 0) {
                                annotations.append(added ? ", " : "(");
                                added = true;
                                annotations.append("required=false");
                            }
                            if (added) {
                                annotations.append(")");
                            }
                            annotations.append("\n");
                            break;
                        }
                        case 2: {
                            boolean added;
                            if (fieldMapping.getMaxOccurs() > 1) {
                                if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlChildren")) {
                                    importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlChildren");
                                }
                                annotations.append(declaration.indent);
                                annotations.append("@XmlChildren");
                                added = false;
                                if (newFieldName != fieldMapping.getName()) {
                                    annotations.append(added ? ", " : "(");
                                    added = true;
                                    annotations.append("name=\"");
                                    annotations.append(fieldMapping.getName());
                                    annotations.append("\"");
                                }
                                if (fieldMapping.getMinOccurs() == 0) {
                                    annotations.append(added ? ", " : "(");
                                    added = true;
                                    annotations.append("minOccurs=0");
                                }
                                if (fieldMapping.getMaxOccurs() != Integer.MAX_VALUE) {
                                    annotations.append(added ? ", " : "(");
                                    added = true;
                                    annotations.append("maxOccurs=" + fieldMapping.getMaxOccurs());
                                }
                                if (added) {
                                    annotations.append(")");
                                }
                                annotations.append("\n");
                                break;
                            }
                            if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlChild")) {
                                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlChild");
                            }
                            annotations.append(declaration.indent);
                            annotations.append("@XmlChild");
                            added = false;
                            if (newFieldName != fieldMapping.getName()) {
                                annotations.append(added ? ", " : "(");
                                added = true;
                                annotations.append("name=\"");
                                annotations.append(fieldMapping.getName());
                                annotations.append("\"");
                            }
                            if (fieldMapping.getMinOccurs() == 0) {
                                annotations.append(added ? ", " : "(");
                                added = true;
                                annotations.append("required=false");
                            }
                            if (added) {
                                annotations.append(")");
                            }
                            annotations.append("\n");
                            break;
                        }
                        case 8: {
                            if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlContent")) {
                                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlContent");
                            }
                            annotations.append(declaration.indent);
                            annotations.append("@XmlContent\n");
                            break;
                        }
                        case 4: {
                            boolean added;
                            if (fieldMapping.getMaxOccurs() > 1) {
                                if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlChildren")) {
                                    importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlChildren");
                                }
                                annotations.append(declaration.indent);
                                annotations.append("@XmlChildren");
                                added = false;
                                annotations.append("(direct=true");
                                added = true;
                                if (newFieldName != fieldMapping.getName()) {
                                    annotations.append(added ? ", " : "(");
                                    added = true;
                                    annotations.append("name=\"");
                                    annotations.append(fieldMapping.getName());
                                    annotations.append("\"");
                                }
                                if (fieldMapping.getMinOccurs() == 0) {
                                    annotations.append(added ? ", " : "(");
                                    added = true;
                                    annotations.append("minOccurs=0");
                                }
                                if (fieldMapping.getMaxOccurs() != Integer.MAX_VALUE) {
                                    annotations.append(added ? ", " : "(");
                                    added = true;
                                    annotations.append("maxOccurs=" + fieldMapping.getMaxOccurs());
                                }
                                if (added) {
                                    annotations.append(")");
                                }
                                annotations.append("\n");
                                break;
                            }
                            if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlChild")) {
                                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlChild");
                            }
                            annotations.append(declaration.indent);
                            annotations.append("@XmlChild");
                            added = false;
                            annotations.append("(direct=true");
                            added = true;
                            if (newFieldName != fieldMapping.getName()) {
                                annotations.append(added ? ", " : "(");
                                added = true;
                                annotations.append("name=\"");
                                annotations.append(fieldMapping.getName());
                                annotations.append("\"");
                            }
                            if (fieldMapping.getMinOccurs() == 0) {
                                annotations.append(added ? ", " : "(");
                                added = true;
                                annotations.append("required=false");
                            }
                            if (added) {
                                annotations.append(")");
                            }
                            annotations.append("\n");
                            break;
                        }
                        case 16: {
                            if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlParent")) {
                                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlParent");
                            }
                            annotations.append(declaration.indent);
                            annotations.append("@XmlParent\n");
                            break;
                        }
                        case 32: {
                            if (!importsToAdd.contains("org.ow2.opensuit.xmlmap.annotations.XmlRoot")) {
                                importsToAdd.add("org.ow2.opensuit.xmlmap.annotations.XmlRoot");
                            }
                            annotations.append(declaration.indent);
                            annotations.append("@XmlRoot\n");
                        }
                    }
                    Migrator.info(javaOldSource, "new name: " + newFieldName + " annotations: \n" + annotations.toString());
                    try {
                        fieldDeclMatcher.appendReplacement(tempBuffer, annotations.toString() + declaration.toCode());
                    }
                    catch (IllegalArgumentException e) {
                        Migrator.error(javaOldSource, "Illegal argument with replacement: \n" + annotations.toString() + declaration.toCode(), null);
                        throw e;
                    }
                }
                fieldDeclMatcher.appendTail(tempBuffer);
                sourceCode = tempBuffer;
                sourceCode = Migrator.replaceImports(javaOldSource, sourceCode, importsToRemove, importsToAdd);
                mapping = method.getElementMappings(element.getMappedClass(), true);
                allFieldMappings = mapping.getMappings(0);
                for (int i = 0; i < allFieldMappings.length; ++i) {
                    String newFieldName = Migrator.getMigratedFieldName(allFieldMappings[i]);
                    Pattern p = Pattern.compile("\\b" + allFieldMappings[i].getField().getName() + "\\b");
                    Matcher m = p.matcher(sourceCode);
                    tempBuffer = new StringBuffer(sourceCode.length());
                    while (m.find()) {
                        m.appendReplacement(tempBuffer, newFieldName);
                    }
                    m.appendTail(tempBuffer);
                    sourceCode = tempBuffer;
                }
                break;
            }
        }
        Migrator.writeFileContent(javaNewSource, sourceCode);
    }

    private static String buildDocAnnotation(String doc) {
        if (doc == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("@XmlDoc(\"");
        block6: for (int i = 0; i < doc.length(); ++i) {
            char c = doc.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\"': {
                    sb.append("\\\\\"");
                    continue block6;
                }
                case '$': {
                    sb.append("\\$");
                    continue block6;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        sb.append("\")\n");
        return sb.toString();
    }

    private static String getMigratedFieldName(FieldMapping fieldMapping) {
        String name = fieldMapping.getName();
        if (name != null && !javaKeyWords.contains(name = Character.toLowerCase(name.charAt(0)) + name.substring(1))) {
            return name;
        }
        name = ClassHelper.getSimpleName((Class)fieldMapping.getBaseClass());
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        return name;
    }

    private static List tokenize(String declaration, String prefix) {
        String[] tokens;
        int idx;
        ArrayList<String> ret = new ArrayList<String>();
        if (declaration == null) {
            return ret;
        }
        if (prefix != null && (idx = declaration.indexOf(prefix)) >= 0) {
            declaration = declaration.substring(idx + prefix.length());
        }
        if ((tokens = declaration.split(",")) == null || tokens.length == 0) {
            return ret;
        }
        for (int i = 0; i < tokens.length; ++i) {
            ret.add(tokens[i].trim());
        }
        return ret;
    }

    static {
        javaKeyWords.add("if");
        javaKeyWords.add("then");
        javaKeyWords.add("else");
        javaKeyWords.add("switch");
        javaKeyWords.add("case");
        javaKeyWords.add("break");
        javaKeyWords.add("return");
        javaKeyWords.add("continue");
        javaKeyWords.add("do");
        javaKeyWords.add("while");
        javaKeyWords.add("public");
        javaKeyWords.add("private");
        javaKeyWords.add("static");
        javaKeyWords.add("final");
        javaKeyWords.add("class");
        javaKeyWords.add("interface");
        javaKeyWords.add("enum");
        javaKeyWords.add("new");
        javaKeyWords.add("int");
        javaKeyWords.add("byte");
        javaKeyWords.add("char");
        javaKeyWords.add("null");
        javaKeyWords.add("true");
        javaKeyWords.add("false");
        javaKeyWords.add("boolean");
        javaKeyWords.add("this");
        javaKeyWords.add("void");
    }

    private static class FieldDeclaration {
        String indent;
        String visibility;
        String statik;
        String type;
        String name;
        String sep;

        public FieldDeclaration(Matcher matcher) {
            this.indent = matcher.group(1);
            this.indent = this.indent == null ? "" : this.indent.replaceAll("[\\n\\r]", "");
            this.visibility = matcher.group(2);
            this.statik = matcher.group(4);
            this.type = matcher.group(5);
            this.name = matcher.group(7);
            this.sep = matcher.group(8);
        }

        public String toCode() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.indent);
            if (this.visibility != null) {
                sb.append(this.visibility);
                sb.append(' ');
            }
            if (this.statik != null) {
                sb.append(this.statik);
                sb.append(' ');
            }
            sb.append(this.type);
            sb.append(' ');
            sb.append(this.name);
            sb.append(this.sep);
            return sb.toString();
        }
    }

    private static class TypeDeclaration {
        String visibility;
        String abstrct;
        String type;
        String name;
        List extendsList;
        List implementsList;
        List throwsList;

        public TypeDeclaration(Matcher matcher) {
            this.visibility = matcher.group(1);
            this.abstrct = matcher.group(3);
            this.type = matcher.group(4);
            this.name = matcher.group(5);
            String extendsStr = matcher.group(6);
            String implementsStr = matcher.group(8);
            String throwsStr = matcher.group(10);
            this.extendsList = Migrator.tokenize(extendsStr, "extends");
            this.implementsList = Migrator.tokenize(implementsStr, "implements");
            this.throwsList = Migrator.tokenize(throwsStr, "throws");
        }

        public String toCode() {
            int i;
            StringBuffer sb = new StringBuffer();
            if (this.visibility != null) {
                sb.append(this.visibility);
                sb.append(' ');
            }
            if (this.abstrct != null) {
                sb.append("abstract ");
            }
            sb.append(this.type);
            sb.append(' ');
            sb.append(this.name);
            if (this.extendsList != null && this.extendsList.size() > 0) {
                sb.append(" extends");
                for (i = 0; i < this.extendsList.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(' ');
                    sb.append(this.extendsList.get(i));
                }
            }
            if (this.implementsList != null && this.implementsList.size() > 0) {
                sb.append(" implements");
                for (i = 0; i < this.implementsList.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(' ');
                    sb.append(this.implementsList.get(i));
                }
            }
            if (this.throwsList != null && this.throwsList.size() > 0) {
                sb.append(" throws");
                for (i = 0; i < this.throwsList.size(); ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(' ');
                    sb.append(this.throwsList.get(i));
                }
            }
            return sb.toString();
        }
    }
}

