/**
 * Copyright (c) 2007-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap;

import java.util.List;

import org.ow2.easywsdl.extensions.wsdl4complexwsdl.api.Description;

/**
 * @author chamerling - EBM WebSourcing
 */
public class ServiceContext<E> {

    /**
     * List of Axis2 modules
     */
    private List<String> modules;

    /**
     * Service parameters
     */
    private String serviceParams;

    /**
     * The service class loader
     */
    private ClassLoader classloader;
    
    /**
     * The service description
     */
    private Description serviceDescription;

    /**
     * Will be provides or consumes block
     */
    private E e;

    public ServiceContext(E e) {
        this.e = e;
    }

    /**
     * @return the classloader
     */
    public ClassLoader getClassloader() {
        return classloader;
    }

    public E getConfig() {
        return this.e;
    }

    /**
     * @return the modules
     */
    public List<String> getModules() {
        return modules;
    }

    /**
     * @return the serviceParams
     */
    public String getServiceParams() {
        return serviceParams;
    }

    /**
     * @param classloader
     *            the classloader to set
     */
    public void setClassloader(ClassLoader classloader) {
        this.classloader = classloader;
    }

    /**
     * @param modules
     *            the modules to set
     */
    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    /**
     * @param serviceParams
     *            the serviceParams to set
     */
    public void setServiceParams(String serviceParams) {
        this.serviceParams = serviceParams;
    }

    public Description getServiceDescription() {
        return serviceDescription;
    }

    public void setServiceDescription(Description serviceDescription) {
        this.serviceDescription = serviceDescription;
    }
    
}
