/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.File;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
abstract class AbstractAxis2DirBasedObject {

    private final File baseDir;
    private boolean isSetUp;

    public AbstractAxis2DirBasedObject(File baseDir) {
        this.baseDir = baseDir;
        this.isSetUp = false;
    }

    protected final File getBaseDir() {
        return baseDir;
    }
    
    protected void createDirIfNeeded(File dir) {
        dir.mkdir();
        assert dir.exists();
    }

    protected final boolean isSetUp() {
        return isSetUp;
    }
    
    public final void setUp() {
        createDirIfNeeded(baseDir);
        specificSetUp();
        isSetUp = true;
    }

    protected abstract void specificSetUp();

}
