/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;

import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.ow2.petals.binding.soap.listener.outgoing.PetalsServiceClient;
import org.ow2.petals.component.framework.jbidescriptor.generated.Provides;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class Axis2Client extends AbstractAxis2RepositoryBasedObject {

    private final URL wsdlURL;

    private final QName wsdlServiceName;

    private final String portName;

    private final Logger logger;

    private final MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager;

    private final Provides provides;

    // FIXME : eradicate petalsService and replace it by Axis2Client everywhere,
    // instantiation directly an Axis2 ServiceClient. Otherly said, use the
    // simple way!
    private PetalsServiceClient petalsServiceClient;

    public Axis2Client(File baseDir, Axis2Config config, URL wsdlURL, QName wsdlServiceName,
            String portName, Logger logger,
            final MultiThreadedHttpConnectionManager multiThreadedHttpConnectionManager,
            final Provides provides) {
        super(baseDir, config);
        this.wsdlURL = wsdlURL;
        this.wsdlServiceName = wsdlServiceName;
        this.portName = portName;
        this.logger = logger;
        this.petalsServiceClient = null;
        this.multiThreadedHttpConnectionManager = multiThreadedHttpConnectionManager;
        this.provides = provides;
    }

    @Override
    protected void specificSetUp() {
        super.specificSetUp();

        try {
            petalsServiceClient = new PetalsServiceClient(getConfigurationContext(), wsdlURL,
                    wsdlServiceName, portName, multiThreadedHttpConnectionManager, provides);
            petalsServiceClient.setLogger(logger);
        } catch (AxisFault af) {
            throw new UncheckedException(af);
        }
    }

    public void submitRequestInOutMep(String operationName, String soapBody) {
        QName operationQName = new QName(operationName);
        OMElement xmlPayload = createXmlPayloadInOMElement(soapBody);

        try {
            petalsServiceClient.sendReceive(operationQName, xmlPayload, null);

        } catch (AxisFault af) {
            throw new UncheckedException(af);
        }
    }

    public void submitRequestInOnlyMep(String operationName, String soapBody) {
        QName operationQName = new QName(operationName);
        OMElement xmlPayload = createXmlPayloadInOMElement(soapBody);

        try {
            petalsServiceClient.fireAndForget(operationQName, xmlPayload, null);
        } catch (AxisFault af) {
            throw new UncheckedException(af);
        }
    }

    public void submitRequestRobustInOnlyMep(String operationName, String soapBody) {
        QName operationQName = new QName(operationName);
        OMElement xmlPayload = createXmlPayloadInOMElement(soapBody);

        try {
            petalsServiceClient.sendRobust(operationQName, xmlPayload, null);
        } catch (AxisFault af) {
            throw new UncheckedException(af);
        }
    }

    public void submitRequestWithAttachments(String operationName, String soapBody,
            Map<String, DataHandler> attachments) {
        QName operationQName = new QName(operationName);
        OMElement xmlPayload = createXmlPayloadInOMElement(soapBody);

        try {
            petalsServiceClient.getOptions().setProperty(org.apache.axis2.Constants.Configuration.ENABLE_MTOM, org.apache.axis2.Constants.VALUE_TRUE);

            petalsServiceClient.sendReceive(operationQName, xmlPayload, null);
        } catch (AxisFault af) {
            throw new UncheckedException(af);
        }
    }

    private OMElement createXmlPayloadInOMElement(String soapBody) {
        InputStream inputStream = new ByteArrayInputStream(soapBody.getBytes());
        OMElement xmlPayload = null;

        try {
            StAXOMBuilder builder = new StAXOMBuilder(inputStream);
            xmlPayload = builder.getDocumentElement();
        } catch (XMLStreamException xse) {
            throw new UncheckedException(xse);
        }
        return xmlPayload;
    }

}
