/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class Axis2Config extends AbstractNamedConfig {

    private final Map<String, MessageReceiverConfig> messageReceivers;

    private final Map<String, TransportReceiverConfig> transportReceivers;

    private final Map<String, TransportSenderConfig> transportSenders;

    private final Map<String, PhaseOrderConfig> phaseOrders;

    public Axis2Config(String name) {
        super(name);
        this.messageReceivers = new LinkedHashMap<String, MessageReceiverConfig>();
        this.transportReceivers = new LinkedHashMap<String, TransportReceiverConfig>();
        this.transportSenders = new LinkedHashMap<String, TransportSenderConfig>();
        this.phaseOrders = new LinkedHashMap<String, PhaseOrderConfig>();
    }

    @Override
    public void dump(Writer writer) throws IOException {
        writer.write(String.format("<axisconfig name='%s'>\n", getName()));
        for (Map.Entry<String, String> entry : getParameters().entrySet()) {
            writer.write(String.format("<parameter name='%s'>%s</parameter>\n", entry.getKey(),
                    entry.getValue()));
        }
        writer.write("<messageReceivers>\n");
        for (MessageReceiverConfig messageReceiver : messageReceivers.values()) {
            messageReceiver.dump(writer);
        }
        writer.write("</messageReceivers>\n");

        writer.write("<messageFormatters/>\n");

        writer.write("<messageBuilders/>\n");

        for (TransportReceiverConfig transportReceiver : transportReceivers.values()) {
            transportReceiver.dump(writer);
        }

        for (TransportSenderConfig transportSender : transportSenders.values()) {
            transportSender.dump(writer);
        }

        for (PhaseOrderConfig phaseOrder : phaseOrders.values()) {
            phaseOrder.dump(writer);
        }

        writer.write("</axisconfig>");
    }

    public void addMessageReceiver(MessageReceiverConfig messageReceiverConfig) {
        assert messageReceiverConfig != null;
        this.messageReceivers.put(messageReceiverConfig.getMep(), messageReceiverConfig);

    }

    public void addTransportReceiver(TransportReceiverConfig transportReceiverConfig) {
        assert transportReceiverConfig != null;
        this.transportReceivers.put(transportReceiverConfig.getName(), transportReceiverConfig);
    }

    public void addTransportSender(TransportSenderConfig transportSenderConfig) {
        assert transportSenderConfig != null;
        this.transportSenders.put(transportSenderConfig.getName(), transportSenderConfig);
    }

    public void addPhaseOrder(PhaseOrderConfig phaseOrderConfig) {
        assert phaseOrderConfig != null;
        this.phaseOrders.put(phaseOrderConfig.getName(), phaseOrderConfig);
    }

}
