/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

import com.ebmwebsourcing.easycommons.lang.UncheckedException;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class Axis2Repository extends AbstractAxis2DirBasedObject {

    private final File modulesDir;

    private final File servicesDir;

    public Axis2Repository(File baseDir) {
        super(baseDir);
        this.modulesDir = new File(baseDir, Constants.AXIS2_REPOSITORY_MODULES_DIR_NAME);
        this.servicesDir = new File(baseDir, Constants.AXIS2_REPOSITORY_SERVICES_DIR_NAME);
    }

    public void specificSetUp() {
        createDirIfNeeded(modulesDir);
        createDirIfNeeded(servicesDir);
    }

    public void deployService(ServiceConfig serviceConfig) {
        assert isSetUp() : "Repository must first be set up before deploying a service.";

        File serviceDir = new File(servicesDir, serviceConfig.getName());
        assert !serviceDir.exists() : 
            String.format("Repository already contains a service called '%s'.", serviceConfig.getName());
        createDirIfNeeded(serviceDir);

        File serviceMetaInfDir = new File(serviceDir, Constants.AXIS2_SERVICES_XML_METAINF_DIR_NAME);
        createDirIfNeeded(serviceMetaInfDir);
        File serviceXmlFile = new File(serviceMetaInfDir, Constants.AXIS2_SERVICES_XML_FILE_NAME);
        FileWriter fw;
        try {
            fw = new FileWriter(serviceXmlFile);
            serviceConfig.dump(fw);
            fw.close();
        } catch (IOException e) {
            throw new UncheckedException(e);
        }
    }
}
