/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.IOException;
import java.io.Writer;

import org.apache.axis2.engine.MessageReceiver;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class MessageReceiverConfig extends AbstractConfig {

    private final String mep;

    private final Class<? extends MessageReceiver> implClass;

    public MessageReceiverConfig(String mep, Class<? extends MessageReceiver> implClass) {
        assert mep != null;
        assert implClass != null;
        this.mep = mep;
        this.implClass = implClass;
    }

    
    String getMep() {
        return mep;
    }
    
    @Override
    public void dump(Writer writer) throws IOException {
        writer.write(String.format("<messageReceiver mep='%s' class='%s'/>", mep, implClass.getName()));
    }

}
