/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class OperationConfig extends AbstractNamedConfig {

    private final List<String> actionMappings;
    
    
    public OperationConfig(String name) {
        super(name);
        this.actionMappings = new ArrayList<String>();
    }
    
    public void addActionMapping(String actionMapping) {
        assert actionMapping != null;
        actionMappings.add(actionMapping);
    }

    
    @Override
    public void dump(Writer writer) throws IOException {
        writer.write(String.format("<operation name='%s'>\n", getName()));
        for (String actionMapping : actionMappings) {
            writer.write(String.format("<actionMapping>%s</actionMapping>\n", actionMapping));
        }
        writer.write(String.format("</operation>\n"));
    }
}
