/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class ServiceConfig extends AbstractNamedConfig {

    private final List<String> transports;
    private final Map<String, OperationConfig> operations;
    
    
    public ServiceConfig(String name) {
        super(name);
        this.transports = new ArrayList<String>();
        this.operations = new LinkedHashMap<String, OperationConfig>(); 
    }
    
    public void addTransport(String transport) {
        assert transport != null;
        transports.add(transport);
    }
    
    
    @Override
    public void dump(Writer writer) throws IOException {
        writer.write(String.format("<service name='%s'>\n", getName()));
        writer.write("  <transports>\n");
        for (String transport : transports) {
            writer.write(String.format("  <transport>%s</transport>\n", transport));
        }
        writer.write("  </transports>\n");
        for (OperationConfig operation : operations.values()) {
            operation.dump(writer);
        }
        writer.write("</service>\n");
    }

    public void addOperation(OperationConfig operationConfig) {
        assert operationConfig != null;
        operations.put(operationConfig.getName(), operationConfig);
    }

}
