/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.axis;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;

import org.apache.axis2.transport.TransportSender;

/**
 * @author Marc Jambert - EBM WebSourcing
 */
public class TransportSenderConfig extends AbstractNamedWithImplClassConfig {

    public TransportSenderConfig(String name, Class<? extends TransportSender> implClass) {
        super(name, implClass);
        assert implClass != null;
    }

    @Override
    public void dump(Writer writer) throws IOException {
        writer.write(String.format("<transportSender name='%s' class='%s'>\n", getName(),
                getImplClass().getName()));
        for (Map.Entry<String, String> entry : getParameters().entrySet()) {
            writer.write(String.format("<parameter name='%s'>%s</parameter>\n", entry.getKey(),
                    entry.getValue()));
        }
        writer.write("</transportSender>");
    }
}
