/**
 * Copyright (c) 2006-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.exception;

import java.net.URI;

public class ServiceClientPoolExhaustedException extends Exception {

    private static final long serialVersionUID = -6514663433759106244L;

    public ServiceClientPoolExhaustedException(final String address, final String operation,
            final URI mep) {
        super("Cannot get a service client '" + address + ", " + operation + ", " + mep.toString()
                + "' from the pool because none is available. Retry later !");
    }

}
