/**
 * Copyright (c) 2007-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.listener.incoming;

import static org.ow2.petals.binding.soap.SoapConstants.Axis2.SOAP_EXTERNAL_LISTENER_SERVICE_PARAM;

import java.util.logging.Level;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.ow2.petals.binding.soap.SoapComponent;
import org.ow2.petals.binding.soap.util.SUPropertiesHelper;
import org.ow2.petals.component.framework.api.exception.PEtALSCDKException;
import org.ow2.petals.component.framework.listener.AbstractExternalListener;

/**
 * The SOAP external listener.
 * @author Christophe HAMERLING - EBM WebSourcing
 */
public class SoapExternalListener extends AbstractExternalListener {

    private SoapExternalListenerManager externalListenerManager;

    private String serviceName = null;

    /*
     * (non-Javadoc)
     * 
     * @see org.ow2.petals.component.framework.listener.AbstractListener#init()
     */
    @Override
    public void init() {
        this.externalListenerManager = ((SoapComponent) getComponent())
                .getExternalListenerManager();
        this.serviceName = SUPropertiesHelper.getServiceName(getExtensions());

        // allow address
        if (this.serviceName == null) {
            this.serviceName = SUPropertiesHelper.getAddress(getExtensions());
        }
    }

    /**
     * As there is a single SOAP listener for all incoming soap requests, this
     * method only references the given address. External calls for non
     * registered addresses will be ignored.
     * 
     * @throws PEtALSCDKException
     */
    @Override
    public void start() throws PEtALSCDKException {
        this.getLogger().log(Level.FINE, "Starting listening on " + this.serviceName);
        this.externalListenerManager.getAddresses().add(this.serviceName);

        ConfigurationContext axisConfiguration = ((SoapComponent) getComponent()).getSoapContext()
                .getAxis2ConfigurationContext();
        AxisConfiguration axisConf = axisConfiguration.getAxisConfiguration();

        try {
            AxisService axisService = axisConf.getService(this.serviceName);
            Parameter soapExternalListenerParam = new Parameter(SOAP_EXTERNAL_LISTENER_SERVICE_PARAM, this);
            axisService.addParameter(soapExternalListenerParam);
        } catch (AxisFault af) {
            throw new PEtALSCDKException(af);
        }
    }

    /**
     * Unreference the given address. After address removal, it will be
     * impossible to contact service from outside.
     */
    @Override
    public void stop() {
        this.getLogger().log(Level.FINE, "Stopping listening on " + this.serviceName);
        this.externalListenerManager.getAddresses().remove(this.serviceName);
    }

}
