/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

import org.ow2.petals.binding.soap.SoapConstants;

/**
 * @author Adrien Ruffie - EBM WebSourcing
 */
public class HTTPSConfig {
    
    final private HTTPSKeystoreConfig httpsKeystoreConfig;

    final private HTTPSTruststoreConfig httpsTruststoreConfig;
        
    final private int httpsPort;

    final private String httpsRestrictedIP;

    final private int acceptorSize;
    
    final private boolean httpsClientAuthEnabled;

    HTTPSConfig(String httpsRestrictedIP, int httpsPort, int acceptorSize,
            HTTPSTruststoreConfig httpsTruststoreConfig, HTTPSKeystoreConfig httpsKeystoreConfig,
            final boolean httpsClientAuthEnabled) {

        this.httpsTruststoreConfig = httpsTruststoreConfig;
        this.httpsKeystoreConfig = httpsKeystoreConfig;
        this.httpsPort = httpsPort;
        this.httpsRestrictedIP = httpsRestrictedIP;
        this.acceptorSize = acceptorSize;
        this.httpsClientAuthEnabled = httpsClientAuthEnabled;
    }
    
    public HTTPSConfig(String httpsRestrictedIP, int httpsPort, int acceptorSize, HTTPSKeystoreConfig httpsKeystoreConfig) {
        super();
        this.httpsKeystoreConfig = httpsKeystoreConfig;
        this.httpsPort = httpsPort;
        this.httpsRestrictedIP = httpsRestrictedIP;
        this.acceptorSize = acceptorSize;
        this.httpsTruststoreConfig = null;
        this.httpsClientAuthEnabled = SoapConstants.HttpServer.DEFAULT_HTTPS_CLIENT_AUTH_ENABLED;
    }

    /**
     * @return the httpsTruststoreConfig
     */
    public HTTPSTruststoreConfig getHttpsTruststoreConfig() {
        return httpsTruststoreConfig;
    }

    /**
     * @return the acceptorPoolSize
     */
    public int getAcceptorSize() {
        return acceptorSize;
    }

    /**
     * @return the httpsPort
     */
    public int getHttpsPort() {
        return httpsPort;
    }
    
    /**
     * @return the httpsRestrictedIP
     */
    public String getHttpsRestrictedIP() {
        return httpsRestrictedIP;
    }

    /**
     * @return the httpsKeystoreConfig
     */
    public HTTPSKeystoreConfig getHttpsKeystoreConfig() {
        return httpsKeystoreConfig;
    }

    /**
     * @return the httpsClientAuthEnabled
     */
    public boolean isHttpsClientAuthEnabled() {
        return httpsClientAuthEnabled;
    }
}
