/**
 * Copyright (c) 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

import org.ow2.petals.probes.api.key.ProbeKey;
import org.ow2.petals.probes.api.probes.CounterProbe;
import org.ow2.petals.probes.api.probes.GaugeProbe;
import org.ow2.petals.probes.api.probes.KeyedCounterProbeWithExecutionStatus;
import org.ow2.petals.probes.api.probes.KeyedResponseTimeProbe;

/**
 * Bean class containing the technical monitoring probes about incoming
 * requests.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class IncomingProbes {

    /**
     * The probe counting the number of requests on an unknown servlet.
     */
    final protected CounterProbe probeUnknownServlet;

    /**
     * The probe counting the number of requests on information servlet (the
     * welcom servlet and the servlet listing ws-services).
     */
    final public CounterProbe probeInformationServlet;

    /**
     * The probe measuring the allocated threads of the pool.
     */
    final public GaugeProbe<Long, Long> probeHttpServerThreadPoolAllocatedThreads;

    /**
     * The probe measuring the idle threads of the pool.
     */
    final public GaugeProbe<Long, Long> probeHttpServerThreadPoolIdleThreads;

    /**
     * The probe measuring the enqueued requests of the thread pool.
     */
    final public GaugeProbe<Long, Long> probeHttpServerThreadPoolQueuedRequests;

    /**
     * The probe counting the number of ws-request invocations.
     */
    final public KeyedCounterProbeWithExecutionStatus<ProbeKey> probeHttpRequestsInvocationsCount;

    /**
     * The probe measuring the response time of ws-requests executions.
     */
    final public KeyedResponseTimeProbe<IncomingServiceKey> probeHttpRequestsInvocationsResponseTime;

    /**
     * 
     * @param probeUnknownServlet
     *            The probe counting the number of requests on an unknown
     *            servlet.
     * @param probeInformationServlet
     *            The probe counting the number of requests on information
     *            servlet.
     * @param probeHttpServerThreadPoolAllocatedThreads
     *            The probe measuring the allocated threads of the pool.
     * @param probeHttpServerThreadPoolIdleThreads
     *            The probe measuring the idle threads of the pool.
     * @param probeHttpServerThreadPoolQueuedRequests
     *            The probe measuring the enqueued requests of the thread pool.
     * @param probeHttpRequestsInvocationsCount
     *            The probe counting the number of ws-request invocations.
     * @param probeHttpRequestsInvocationsResponseTime
     *            The probe measuring the response time of ws-requests
     *            executions.
     */
    public IncomingProbes(
            final CounterProbe probeUnknownServlet,
            final CounterProbe probeInformationServlet,
            final GaugeProbe<Long, Long> probeHttpServerThreadPoolAllocatedThreads,
            final GaugeProbe<Long, Long> probeHttpServerThreadPoolIdleThreads,
            final GaugeProbe<Long, Long> probeHttpServerThreadPoolQueuedRequests,
            final KeyedCounterProbeWithExecutionStatus<ProbeKey> probeHttpRequestsInvocationsCount,
            final KeyedResponseTimeProbe<IncomingServiceKey> probeHttpRequestsInvocationsResponseTime) {
        super();
        this.probeUnknownServlet = probeUnknownServlet;
        this.probeInformationServlet = probeInformationServlet;
        this.probeHttpServerThreadPoolAllocatedThreads = probeHttpServerThreadPoolAllocatedThreads;
        this.probeHttpServerThreadPoolIdleThreads = probeHttpServerThreadPoolIdleThreads;
        this.probeHttpServerThreadPoolQueuedRequests = probeHttpServerThreadPoolQueuedRequests;
        this.probeHttpRequestsInvocationsCount = probeHttpRequestsInvocationsCount;
        this.probeHttpRequestsInvocationsResponseTime = probeHttpRequestsInvocationsResponseTime;
    }

}
