/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.SessionContext;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.transport.TransportListener;
import org.ow2.petals.binding.soap.listener.incoming.SoapServerConfig;

/**
 * @author Adrien Ruffie - EBM WebSourcing
 */
public class SOAPHttpsTransportListener implements TransportListener {

    private SoapServerConfig config;

    public SOAPHttpsTransportListener(SoapServerConfig config) {
        this.config = config;
    }
    
    @Override
    public void destroy() {
        // TODO Auto-generated method stub
    }

    @Override
    public EndpointReference getEPRForService(String serviceName, String ip) throws AxisFault {
        return this.getEPRsForService(serviceName, ip)[0];
    }

    @Override
    public EndpointReference[] getEPRsForService(String serviceName, String ip) throws AxisFault {
        if (this.config != null) {
            return this.config.getEPRsForAxisService(serviceName, Constants.TRANSPORT_HTTPS);
        } else {
            throw new AxisFault("Unable to generate EPR for the transport: " + Constants.TRANSPORT_HTTPS);
        }
    }

    @Override
    public SessionContext getSessionContext(MessageContext messageContext) {
        // TODO Auto-generated method stub
        return null;
    }

    @Override
    public void init(ConfigurationContext axisConf, TransportInDescription transprtInDesc)
            throws AxisFault {
        this.config.initTransportListenerForAxis(transprtInDesc, Constants.TRANSPORT_HTTPS);
    }

    @Override
    public void start() throws AxisFault {
        // TODO Auto-generated method stub
    }

    @Override
    public void stop() throws AxisFault {
        // TODO Auto-generated method stub
    }

}
