/**
 * Copyright (c) 2008-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

import java.util.concurrent.atomic.AtomicLong;

/**
 * @author Christophe HAMERLING - EBM WebSourcing
 */
public class ServerStats {

    private long startTime;
    
    private long stopTime;

    private final AtomicLong getRequests;

    private final AtomicLong postRequests;

    /**
     * 
     */
    public ServerStats() {
        this.getRequests = new AtomicLong();
        this.postRequests = new AtomicLong();
    }

    /**
     * 
     * 
     */
    public void newGetRequest() {
        this.getRequests.incrementAndGet();
    }

    /**
     * 
     * @return
     */
    public long getGetRequests() {
        return this.getRequests.get();
    }

    /**
     * 
     * 
     */
    public void newPostRequest() {
        this.postRequests.incrementAndGet();
    }

    /**
     * 
     * @return
     */
    public long getPostRequests() {
        return this.postRequests.get();
    }

    /**
     * @return the startTime
     */
    public long getStartTime() {
        return this.startTime;
    }

    /**
     * @param startTime
     *            the startTime to set
     */
    public void setStartTime(final long startTime) {
        this.startTime = startTime;
    }

    /**
     * @return the stopTime
     */
    public long getStopTime() {
        return stopTime;
    }

    /**
     * @param stopTime the stopTime to set
     */
    public void setStopTime(long stopTime) {
        this.stopTime = stopTime;
    }

}
