/**
 * Copyright (c) 2011-2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

/**
 * @author Adrien Ruffie - EBM WebSourcing
 */
public class ServletServerConfig {

    private String servicesMapping;

    private String servicesContext;

    private int serverMaxPoolSize;

    private int serverMinPoolSize;
    
    private HTTPConfig httpConfig;

    private HTTPSConfig httpsConfig;

    public ServletServerConfig(String servicesMapping, String servicesContext,
             int serverMaxPoolSize, int serverMinPoolSize, HTTPConfig httpConfig, HTTPSConfig httpsConfig) {
        super();
        this.serverMaxPoolSize = serverMaxPoolSize;
        this.serverMinPoolSize = serverMinPoolSize;
        this.httpConfig = httpConfig;
        this.httpsConfig = httpsConfig;
        this.servicesContext = servicesContext;
        this.servicesMapping = servicesMapping;
    }

    public ServletServerConfig(String servicesMapping, String servicesContext,
            int serverMaxPoolSize, int serverMinPoolSize, HTTPConfig httpConfig) {
        super();
        this.servicesMapping = servicesMapping;
        this.servicesContext = servicesContext;
        this.serverMaxPoolSize = serverMaxPoolSize;
        this.serverMinPoolSize = serverMinPoolSize;
        this.httpConfig = httpConfig;
    }

    public ServletServerConfig(String servicesMapping, String servicesContext,
            int serverMaxPoolSize, int serverMinPoolSize, HTTPSConfig httpsConfig) {
        super();
        this.servicesMapping = servicesMapping;
        this.servicesContext = servicesContext;
        this.serverMaxPoolSize = serverMaxPoolSize;
        this.serverMinPoolSize = serverMinPoolSize;
        this.httpsConfig = httpsConfig;
    }

    public int getServerMaxPoolSize() {
        return this.serverMaxPoolSize;
    }

    public int getServerMinPoolSize() {
        return this.serverMinPoolSize;
    }

    /**
     * @return the servicesMapping
     */
    public String getServicesMapping() {
        return servicesMapping;
    }

    /**
     * @return the servicesContext
     */
    public String getServicesContext() {
        return servicesContext;
    }
    
    /**
     * @return the httpConfig
     */
    public HTTPConfig getHttpConfig() {
        return httpConfig;
    }
    
    /**
     * @return the httpsConfig
     */
    public HTTPSConfig getHttpsConfig() {
        return this.httpsConfig;
    }
}
