/**
 * Copyright (c) 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.listener.incoming.jetty;

import javax.servlet.http.HttpServlet;

/**
 * Bean class containing the servlets of the servlet server.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class Servlets {

    /**
     * The servlet processing ws-requests. It's the main servlet.
     */
    final protected HttpServlet soapServicesDispatcherServlet;

    /**
     * The servlet returning the list of ws-services deployed
     */
    final protected HttpServlet soapServicesListingServlet;

    /**
     * The welcom servlet.
     */
    final protected HttpServlet welcomeServlet;

    /**
     * @param soapServicesDispatcherServlet
     *            The servlet processing ws-requests.
     * @param soapServicesListingServlet
     *            The servlet returning the list of ws-services deployed.
     * @param welcomeServlet
     *            The welcom servlet.
     */
    public Servlets(final HttpServlet soapServicesDispatcherServlet,
            final HttpServlet soapServicesListingServlet, final HttpServlet welcomeServlet) {
        super();
        this.soapServicesDispatcherServlet = soapServicesDispatcherServlet;
        this.soapServicesListingServlet = soapServicesListingServlet;
        this.welcomeServlet = welcomeServlet;
    }
}
