/**
 * Copyright (c) 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.listener.outgoing;

import org.ow2.petals.probes.api.key.ProbeKey;
import org.ow2.petals.probes.api.probes.KeyedCounterProbe;
import org.ow2.petals.probes.api.probes.KeyedCounterProbeWithExecutionStatus;
import org.ow2.petals.probes.api.probes.KeyedGaugeProbe;
import org.ow2.petals.probes.api.probes.KeyedResponseTimeProbe;

/**
 * Bean class containing the technical monitoring probes about outgoing
 * requests.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class OutgoingProbes {

    /**
     * The probe counting allocated ws-clients in the pool.
     */
    public final KeyedGaugeProbe<ServiceClientKey, Long, Long> probeWsClientPoolClientsInUse;

    /**
     * The probe counting the number of ws-client pool exhaustions.
     */
    public final KeyedCounterProbe<ProbeKey> probeWsClientPoolExhaustions;

    /**
     * The probe counting external web-service invocation by web-service,
     * web-service operation and MEP.
     */
    public final KeyedCounterProbeWithExecutionStatus<ProbeKey> probeWsRequestsInvocationsCount;

    /**
     * The probe measuring the response time of WS client invocation by external
     * web-service, operation, MEP and execution status.
     */
    public final KeyedResponseTimeProbe<ServiceClientKey> probeWsClientInvocationsResponseTime;

    /**
     * 
     * @param probeWsClientPoolClientsInUse2
     *            The probe counting allocated ws-clients in the pool.
     * @param probeWsClientPoolExhaustions2
     *            The probe counting the number of ws-client pool exhaustions.
     * @param probeWsRequestsInvocationsCount2
     *            The probe counting external web-service invocation
     * @param probeWsClientInvocationsResponseTime
     *            The probe measuring the response time of WS client invocation
     */
    public OutgoingProbes(
            final KeyedGaugeProbe<ServiceClientKey, Long, Long> probeWsClientPoolClientsInUse,
            final KeyedCounterProbe<ProbeKey> probeWsClientPoolExhaustions,
            final KeyedCounterProbeWithExecutionStatus<ProbeKey> probeWsRequestsInvocationsCount,
            final KeyedResponseTimeProbe<ServiceClientKey> probeWsClientInvocationsResponseTime) {
        super();
        this.probeWsClientPoolClientsInUse = probeWsClientPoolClientsInUse;
        this.probeWsClientPoolExhaustions = probeWsClientPoolExhaustions;
        this.probeWsRequestsInvocationsCount = probeWsRequestsInvocationsCount;
        this.probeWsClientInvocationsResponseTime = probeWsClientInvocationsResponseTime;
    }

}
