/**
 * Copyright (c) 2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.monitoring.sensor;

import org.mortbay.thread.BoundedThreadPool;
import org.ow2.petals.probes.api.sensor.detector.DefectCreator;
import org.ow2.petals.probes.api.sensor.detector.GaugeDefectDetector;

/**
 * Defect detector attached to the allocated threads of the HTTP thread pool.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class HttpThreadPoolAllocatedThreadsDefectDetector implements GaugeDefectDetector<Long> {

    /**
     * The HTTP server thread pool
     */
    protected BoundedThreadPool httpThreadPool = null;

    /**
     * The factory creating and sending the defect about the HTTP server thread
     * pool exhausted
     */
    private final DefectCreator httpServerThreadPoolExhaustedDefectCreator;

    /**
     * @param httpServerThreadPoolExhaustedDefectCreator
     *            The factory creating and sending the defect about the HTTP
     *            server thread pool exhausted
     */
    public HttpThreadPoolAllocatedThreadsDefectDetector(
            final DefectCreator httpServerThreadPoolExhaustedDefectCreator) {
        this.httpServerThreadPoolExhaustedDefectCreator = httpServerThreadPoolExhaustedDefectCreator;
    }

    @Override
    public void detect(final Long instantValue) {
        if (this.httpThreadPool.getMaxThreads() - instantValue == 0) {
            // No more threads is available
            this.httpServerThreadPoolExhaustedDefectCreator.createAndSend();
        }
    }

    public final void setHttpThreadPool(final BoundedThreadPool httpThreadPool) {
        this.httpThreadPool = httpThreadPool;
    }
}