/**
 * Copyright (c) 2012 EBM WebSourcing, 2012-2015 Linagora
 * 
 * This program/library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This program/library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program/library; If not, see <http://www.gnu.org/licenses/>
 * for the GNU Lesser General Public License version 2.1.
 */
package org.ow2.petals.binding.soap.monitoring.sensor;

import org.ow2.petals.probes.api.key.ProbeKey;
import org.ow2.petals.probes.api.sensor.detector.KeyedCounterDefectDetector;
import org.ow2.petals.probes.api.sensor.detector.KeyedDefectCreator;

/**
 * Defect detector attached to the ws-clients pools about exhaustion.
 * 
 * @author Christophe DENEUX - Linagora
 */
public class WsClientPoolExhaustionsDefectDetector implements KeyedCounterDefectDetector {

    /**
     * The factory creating and sending the defect about the web-service client
     * pool exhausted
     */
    private final KeyedDefectCreator wsClientPoolExhaustedDefectCreator;

    public WsClientPoolExhaustionsDefectDetector(
            final KeyedDefectCreator wsClientPoolExhaustedDefectCreator) {
        this.wsClientPoolExhaustedDefectCreator = wsClientPoolExhaustedDefectCreator;
    }

    @Override
    public void detectOnIncrement(final ProbeKey key, final long value) {
        // An exhaustion occurs
        this.wsClientPoolExhaustedDefectCreator.createAndSend(key);
    }
}